/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.OracleForUpdateTransformer;
import org.seasar.doma.internal.jdbc.dialect.OraclePagingTransformer;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingFunction;
import org.seasar.doma.jdbc.JdbcMappingHint;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormatter;
import org.seasar.doma.jdbc.SqlLogFormattingFunction;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.CriteriaBuilder;
import org.seasar.doma.jdbc.dialect.StandardDialect;
import org.seasar.doma.jdbc.type.AbstractResultSetType;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.jdbc.type.JdbcTypes;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.LocalDateTimeWrapper;
import org.seasar.doma.wrapper.LocalDateWrapper;
import org.seasar.doma.wrapper.LocalTimeWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;

public class Oracle11Dialect
extends StandardDialect {
    protected static final int UNIQUE_CONSTRAINT_VIOLATION_ERROR_CODE = 1;
    protected static final JdbcType<ResultSet> RESULT_SET = new OracleResultSetType();

    public Oracle11Dialect() {
        this(new Oracle11JdbcMappingVisitor(), new Oracle11SqlLogFormattingVisitor(), new Oracle11ExpressionFunctions());
    }

    public Oracle11Dialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new Oracle11SqlLogFormattingVisitor(), new Oracle11ExpressionFunctions());
    }

    public Oracle11Dialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new Oracle11JdbcMappingVisitor(), sqlLogFormattingVisitor, new Oracle11ExpressionFunctions());
    }

    public Oracle11Dialect(ExpressionFunctions expressionFunctions) {
        this(new Oracle11JdbcMappingVisitor(), new Oracle11SqlLogFormattingVisitor(), expressionFunctions);
    }

    public Oracle11Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new Oracle11ExpressionFunctions());
    }

    public Oracle11Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "oracle";
    }

    @Override
    public boolean supportsBatchUpdateResults() {
        return false;
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        OracleForUpdateTransformer transformer = new OracleForUpdateTransformer(forUpdateType, waitSeconds, aliases);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        OraclePagingTransformer transformer = new OraclePagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        int code = this.getErrorCode(sqlException);
        return 1 == code;
    }

    @Override
    public PreparedSql getSequenceNextValSql(String qualifiedSequenceName, long allocationSize) {
        if (qualifiedSequenceName == null) {
            throw new DomaNullPointerException("qualifiedSequenceName");
        }
        String rawSql = "select " + qualifiedSequenceName + ".nextval from dual";
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList(), SqlLogType.FORMATTED);
    }

    @Override
    public boolean supportsIdentity() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate(SelectForUpdateType type, boolean withTargets) {
        return true;
    }

    @Override
    public boolean supportsResultSetReturningAsOutParameter() {
        return true;
    }

    @Override
    public boolean supportsModOperator() {
        return false;
    }

    @Override
    public boolean supportsMultiRowInsertStatement() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrementWhenInsertingMultipleRows() {
        return false;
    }

    @Override
    public JdbcType<ResultSet> getResultSetType() {
        return RESULT_SET;
    }

    @Override
    public String getScriptBlockDelimiter() {
        return "/";
    }

    @Override
    public ScriptBlockContext createScriptBlockContext() {
        return new Oracle11ScriptBlockContext();
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return new Oracle11CriteriaBuilder();
    }

    public static class Oracle11JdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
        @Override
        public Void visitBooleanWrapper(BooleanWrapper wrapper, JdbcMappingFunction p, JdbcMappingHint q) throws SQLException {
            return (Void)p.apply(wrapper, JdbcTypes.INTEGER_ADAPTIVE_BOOLEAN);
        }
    }

    public static class Oracle11SqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
        protected final DateFormatter dateFormatter = new DateFormatter();
        protected final TimeFormatter timeFormatter = new TimeFormatter();
        protected final TimestampFormatter timestampFormatter = new TimestampFormatter();
        protected final UtilDateFormatter utilDateFormatter = new UtilDateFormatter();
        protected final LocalDateFormatter localDateFormatter = new LocalDateFormatter(this.dateFormatter);
        protected final LocalDateTimeFormatter localDateTimeFormatter = new LocalDateTimeFormatter(this.timestampFormatter);
        protected final LocalTimeFormatter localTimeFormatter = new LocalTimeFormatter(this.timeFormatter);

        @Override
        public String visitBooleanWrapper(BooleanWrapper wrapper, SqlLogFormattingFunction p, Void q) throws RuntimeException {
            return p.apply(wrapper, JdbcTypes.INTEGER_ADAPTIVE_BOOLEAN);
        }

        @Override
        public String visitDateWrapper(DateWrapper wrapper, SqlLogFormattingFunction p, Void q) {
            return p.apply(wrapper, this.dateFormatter);
        }

        @Override
        public String visitLocalDateWrapper(LocalDateWrapper wrapper, SqlLogFormattingFunction p, Void q) throws RuntimeException {
            return p.apply(wrapper, this.localDateFormatter);
        }

        @Override
        public String visitLocalDateTimeWrapper(LocalDateTimeWrapper wrapper, SqlLogFormattingFunction p, Void q) throws RuntimeException {
            return p.apply(wrapper, this.localDateTimeFormatter);
        }

        @Override
        public String visitLocalTimeWrapper(LocalTimeWrapper wrapper, SqlLogFormattingFunction p, Void q) throws RuntimeException {
            return p.apply(wrapper, this.localTimeFormatter);
        }

        @Override
        public String visitTimeWrapper(TimeWrapper wrapper, SqlLogFormattingFunction p, Void q) {
            return p.apply(wrapper, this.timeFormatter);
        }

        @Override
        public String visitTimestampWrapper(TimestampWrapper wrapper, SqlLogFormattingFunction p, Void q) {
            return p.apply(wrapper, this.timestampFormatter);
        }

        @Override
        public String visitUtilDateWrapper(UtilDateWrapper wrapper, SqlLogFormattingFunction p, Void q) {
            return p.apply(wrapper, this.utilDateFormatter);
        }

        protected static class DateFormatter
        implements SqlLogFormatter<Date> {
            protected DateFormatter() {
            }

            @Override
            public String convertToLogFormat(Date value) {
                if (value == null) {
                    return "null";
                }
                return "date'" + String.valueOf(value) + "'";
            }
        }

        protected static class TimeFormatter
        implements SqlLogFormatter<Time> {
            protected TimeFormatter() {
            }

            @Override
            public String convertToLogFormat(Time value) {
                if (value == null) {
                    return "null";
                }
                return "time'" + String.valueOf(value) + "'";
            }
        }

        protected static class TimestampFormatter
        implements SqlLogFormatter<Timestamp> {
            protected TimestampFormatter() {
            }

            @Override
            public String convertToLogFormat(Timestamp value) {
                if (value == null) {
                    return "null";
                }
                return "timestamp'" + String.valueOf(value) + "'";
            }
        }

        protected static class UtilDateFormatter
        implements SqlLogFormatter<java.util.Date> {
            protected UtilDateFormatter() {
            }

            @Override
            public String convertToLogFormat(java.util.Date value) {
                if (value == null) {
                    return "null";
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return "timestamp'" + dateFormat.format(value) + "'";
            }
        }

        protected static class LocalDateFormatter
        implements SqlLogFormatter<LocalDate> {
            protected final DateFormatter delegate;

            protected LocalDateFormatter(DateFormatter delegate) {
                AssertionUtil.assertNotNull(delegate);
                this.delegate = delegate;
            }

            @Override
            public String convertToLogFormat(LocalDate value) {
                if (value == null) {
                    return "null";
                }
                return this.delegate.convertToLogFormat(Date.valueOf(value));
            }
        }

        protected static class LocalDateTimeFormatter
        implements SqlLogFormatter<LocalDateTime> {
            protected final TimestampFormatter delegate;

            protected LocalDateTimeFormatter(TimestampFormatter delegate) {
                AssertionUtil.assertNotNull(delegate);
                this.delegate = delegate;
            }

            @Override
            public String convertToLogFormat(LocalDateTime value) {
                if (value == null) {
                    return "null";
                }
                return this.delegate.convertToLogFormat(Timestamp.valueOf(value));
            }
        }

        protected static class LocalTimeFormatter
        implements SqlLogFormatter<LocalTime> {
            protected final TimeFormatter delegate;

            protected LocalTimeFormatter(TimeFormatter delegate) {
                AssertionUtil.assertNotNull(delegate);
                this.delegate = delegate;
            }

            @Override
            public String convertToLogFormat(LocalTime value) {
                if (value == null) {
                    return "null";
                }
                return this.delegate.convertToLogFormat(Time.valueOf(value));
            }
        }
    }

    public static class Oracle11ExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
        private static final char[] DEFAULT_WILDCARDS = new char[]{'%', '_', '\uff05', '\uff3f'};

        public Oracle11ExpressionFunctions() {
            super(DEFAULT_WILDCARDS);
        }

        public Oracle11ExpressionFunctions(char[] wildcards) {
            super(wildcards);
        }

        protected Oracle11ExpressionFunctions(char escapeChar, char[] wildcards) {
            super(escapeChar, wildcards);
        }
    }

    public static class Oracle11ScriptBlockContext
    extends StandardDialect.StandardScriptBlockContext {
        protected Oracle11ScriptBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Collections.singletonList("declare"));
            this.sqlBlockStartKeywordsList.add(Collections.singletonList("begin"));
        }
    }

    public static class Oracle11CriteriaBuilder
    extends StandardDialect.StandardCriteriaBuilder {
        @Override
        public void forUpdate(final PreparedSqlBuilder buf, ForUpdateOption option, final Consumer<PropertyMetamodel<?>> column, AliasManager aliasManager) {
            option.accept(new ForUpdateOption.Visitor(){

                @Override
                public void visit(ForUpdateOption.Basic basic) {
                    buf.appendSql(" for update");
                    this.of(basic.propertyMetamodels);
                }

                @Override
                public void visit(ForUpdateOption.NoWait noWait) {
                    buf.appendSql(" for update");
                    this.of(noWait.propertyMetamodels);
                    buf.appendSql(" nowait");
                }

                @Override
                public void visit(ForUpdateOption.Wait wait) {
                    buf.appendSql(" for update");
                    this.of(wait.propertyMetamodels);
                    buf.appendSql(" wait ");
                    buf.appendSql(String.valueOf(wait.second));
                }

                private void of(List<PropertyMetamodel<?>> propertyMetamodels) {
                    if (!propertyMetamodels.isEmpty()) {
                        buf.appendSql(" of ");
                        for (PropertyMetamodel<?> p : propertyMetamodels) {
                            column.accept(p);
                            buf.appendSql(", ");
                        }
                        buf.cutBackSql(2);
                    }
                }
            });
        }
    }

    public static class OracleResultSetType
    extends AbstractResultSetType {
        protected static final int CURSOR = -10;

        public OracleResultSetType() {
            super(-10);
        }
    }
}

