/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.List;
import java.util.stream.Collectors;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.internal.util.Zip;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.InsertRow;
import org.seasar.doma.jdbc.query.QueryOperand;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssemblerSupport;

public class OracleUpsertAssembler
implements UpsertAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final DuplicateKeyType duplicateKeyType;
    private final UpsertAssemblerSupport upsertAssemblerSupport;
    private final List<? extends EntityPropertyType<?, ?>> keys;
    private final List<? extends EntityPropertyType<?, ?>> insertPropertyTypes;
    private final List<InsertRow> insertRows;
    private final List<QueryOperandPair> setValues;
    private final QueryOperand.Visitor queryOperandVisitor = new QueryOperandVisitor();

    public OracleUpsertAssembler(UpsertAssemblerContext context) {
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.duplicateKeyType = context.duplicateKeyType;
        this.keys = context.keys;
        this.insertPropertyTypes = context.insertPropertyTypes;
        this.insertRows = context.insertRows;
        this.setValues = context.setValues;
        this.upsertAssemblerSupport = new UpsertAssemblerSupport(context.naming, context.dialect);
    }

    @Override
    public void assemble() {
        this.buf.appendSql("merge into ");
        this.tableNameAndAlias(this.entityType);
        this.buf.appendSql(" using (");
        this.excludeQuery();
        this.buf.appendSql(") ");
        this.excludeAlias();
        this.buf.appendSql(" on (");
        for (EntityPropertyType<?, ?> key : this.keys) {
            this.targetColumn(key);
            this.buf.appendSql(" = ");
            this.excludeColumn(key);
            this.buf.appendSql(" and ");
        }
        this.buf.cutBackSql(5);
        this.buf.appendSql(") when not matched then insert (");
        for (EntityPropertyType<?, ?> p : this.insertPropertyTypes) {
            this.column(p);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(") values (");
        for (EntityPropertyType<?, ?> p : this.insertPropertyTypes) {
            this.excludeColumn(p);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(")");
        if (this.duplicateKeyType == DuplicateKeyType.UPDATE) {
            this.buf.appendSql(" when matched then update set ");
            for (QueryOperandPair pair : this.setValues) {
                this.targetColumn(pair.getLeft().getEntityPropertyType());
                this.buf.appendSql(" = ");
                pair.getRight().accept(this.queryOperandVisitor);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
    }

    private void excludeQuery() {
        for (InsertRow row : this.insertRows) {
            List pairs = Zip.stream(this.insertPropertyTypes, row).collect(Collectors.toList());
            this.buf.appendSql("select ");
            for (Pair pair : pairs) {
                ((QueryOperand)pair.snd).accept(this.queryOperandVisitor);
                this.buf.appendSql(" as ");
                this.column((EntityPropertyType)pair.fst);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
            this.buf.appendSql(" from dual");
            this.buf.appendSql(" union all ");
        }
        this.buf.cutBackSql(11);
    }

    private void tableNameAndAlias(EntityType<?> entityType) {
        String sql = this.upsertAssemblerSupport.targetTable(entityType, UpsertAssemblerSupport.TableNameType.NAME_ALIAS);
        this.buf.appendSql(sql);
    }

    private void excludeAlias() {
        String sql = this.upsertAssemblerSupport.excludeAlias();
        this.buf.appendSql(sql);
    }

    private void targetColumn(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.targetProp(propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
        this.buf.appendSql(sql);
    }

    private void excludeColumn(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.excludeProp(propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
        this.buf.appendSql(sql);
    }

    private void column(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.excludeProp(propertyType, UpsertAssemblerSupport.ColumnNameType.NAME);
        this.buf.appendSql(sql);
    }

    class QueryOperandVisitor
    implements QueryOperand.Visitor {
        QueryOperandVisitor() {
        }

        @Override
        public void visit(QueryOperand.Param param) {
            OracleUpsertAssembler.this.buf.appendParameter(param.inParameter);
        }

        @Override
        public void visit(QueryOperand.Prop prop) {
            String sql = OracleUpsertAssembler.this.upsertAssemblerSupport.excludeProp(prop.propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
            OracleUpsertAssembler.this.buf.appendSql(sql);
        }
    }
}

