/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.StandardAssemblerUtil;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.InsertRow;
import org.seasar.doma.jdbc.query.QueryOperand;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssemblerSupport;

public class SqliteUpsertAssembler
implements UpsertAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final DuplicateKeyType duplicateKeyType;
    private final UpsertAssemblerSupport upsertAssemblerSupport;
    private final boolean isKeysSpecified;
    private final List<? extends EntityPropertyType<?, ?>> keys;
    private final List<? extends EntityPropertyType<?, ?>> insertPropertyTypes;
    private final List<InsertRow> insertRows;
    private final List<QueryOperandPair> setValues;
    private final Naming naming;
    private final Dialect dialect;
    private final ReturningProperties returning;
    private final QueryOperand.Visitor queryOperandVisitor = new QueryOperandVisitor();

    public SqliteUpsertAssembler(UpsertAssemblerContext context) {
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.duplicateKeyType = context.duplicateKeyType;
        this.keys = context.keys;
        this.isKeysSpecified = context.isKeysSpecified;
        this.insertPropertyTypes = context.insertPropertyTypes;
        this.insertRows = context.insertRows;
        this.setValues = context.setValues;
        this.naming = context.naming;
        this.dialect = context.dialect;
        this.returning = context.returning;
        this.upsertAssemblerSupport = new UpsertAssemblerSupport(context.naming, context.dialect);
    }

    @Override
    public void assemble() {
        this.buf.appendSql("insert into ");
        this.tableNameAndAlias(this.entityType);
        this.join(this.insertPropertyTypes, ", ", " (", ")", this.buf, this::column);
        this.buf.appendSql(" values ");
        this.join(this.insertRows, ", ", "", "", this.buf, row -> this.join((Iterable)row, ", ", "(", ")", this.buf, p -> p.accept(this.queryOperandVisitor)));
        if (this.duplicateKeyType == DuplicateKeyType.IGNORE) {
            this.buf.appendSql(" on conflict");
            if (this.isKeysSpecified) {
                this.join(this.keys, ", ", " (", ")", this.buf, this::column);
            }
            this.buf.appendSql(" do nothing");
        } else if (this.duplicateKeyType == DuplicateKeyType.UPDATE) {
            this.buf.appendSql(" on conflict");
            this.join(this.keys, ", ", " (", ")", this.buf, this::column);
            this.buf.appendSql(" do update set ");
            this.join(this.setValues, ", ", "", "", this.buf, p -> {
                this.column(p.getLeft().getEntityPropertyType());
                this.buf.appendSql(" = ");
                p.getRight().accept(this.queryOperandVisitor);
            });
        }
        if (!this.returning.isNone()) {
            StandardAssemblerUtil.assembleReturning(this.buf, this.entityType, this.naming, this.dialect, this.returning);
        }
    }

    private void tableNameAndAlias(EntityType<?> entityType) {
        String sql = this.upsertAssemblerSupport.targetTable(entityType, UpsertAssemblerSupport.TableNameType.NAME_AS_ALIAS);
        this.buf.appendSql(sql);
    }

    private void column(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.prop(propertyType);
        this.buf.appendSql(sql);
    }

    private <T> void join(Iterable<T> iterable, String delimiter, String start, String end, PreparedSqlBuilder buf, Consumer<T> consumer) {
        buf.appendSql(start);
        for (T val : iterable) {
            consumer.accept(val);
            buf.appendSql(delimiter);
        }
        buf.cutBackSql(delimiter.length());
        buf.appendSql(end);
    }

    class QueryOperandVisitor
    implements QueryOperand.Visitor {
        QueryOperandVisitor() {
        }

        @Override
        public void visit(QueryOperand.Param param) {
            SqliteUpsertAssembler.this.buf.appendParameter(param.inParameter);
        }

        @Override
        public void visit(QueryOperand.Prop prop) {
            String sql = SqliteUpsertAssembler.this.upsertAssemblerSupport.excludeProp(prop.propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
            SqliteUpsertAssembler.this.buf.appendSql(sql);
        }
    }
}

