/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.entity.PropertyField;
import org.seasar.doma.internal.jdbc.entity.PropertyPath;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.jdbc.sql.ScalarInParameter;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.entity.ColumnType;
import org.seasar.doma.jdbc.entity.EmbeddedType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.wrapper.Wrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class DefaultPropertyType<ENTITY, BASIC, CONTAINER>
implements EntityPropertyType<ENTITY, BASIC> {
    protected final Class<ENTITY> entityClass;
    protected final Supplier<Scalar<BASIC, CONTAINER>> scalarSupplier;
    protected final String name;
    protected final String simpleName;
    protected final String columnName;
    protected final NamingType namingType;
    protected final boolean insertable;
    protected final boolean updatable;
    protected final boolean quoteRequired;
    protected final PropertyField<ENTITY> field;
    protected final String prefix;
    protected final ColumnType columnType;

    public DefaultPropertyType(Class<ENTITY> entityClass, Supplier<Scalar<BASIC, CONTAINER>> scalarSupplier, String name, String columnName, NamingType namingType, boolean insertable, boolean updatable, boolean quoteRequired) {
        this(entityClass, scalarSupplier, name, columnName, namingType, insertable, updatable, quoteRequired, null);
    }

    public DefaultPropertyType(Class<ENTITY> entityClass, Supplier<Scalar<BASIC, CONTAINER>> scalarSupplier, String name, String columnName, NamingType namingType, boolean insertable, boolean updatable, boolean quoteRequired, EmbeddedType embeddedType) {
        this(entityClass, scalarSupplier, PropertyPath.of(name), columnName, namingType, insertable, updatable, quoteRequired, embeddedType);
    }

    public DefaultPropertyType(Class<ENTITY> entityClass, Supplier<Scalar<BASIC, CONTAINER>> scalarSupplier, PropertyPath path, String columnName, NamingType namingType, boolean insertable, boolean updatable, boolean quoteRequired, EmbeddedType embeddedType) {
        if (entityClass == null) {
            throw new DomaNullPointerException("entityClass");
        }
        if (scalarSupplier == null) {
            throw new DomaNullPointerException("scalarSupplier");
        }
        if (path == null) {
            throw new DomaNullPointerException("path");
        }
        if (columnName == null) {
            throw new DomaNullPointerException("columnName");
        }
        this.entityClass = entityClass;
        this.scalarSupplier = scalarSupplier;
        this.name = path.name();
        int pos = this.name.lastIndexOf(46);
        this.simpleName = pos > -1 ? this.name.substring(pos + 1) : this.name;
        this.namingType = namingType;
        if (embeddedType == null) {
            this.prefix = "";
            this.columnType = null;
        } else {
            this.prefix = embeddedType.prefix();
            this.columnType = embeddedType.columnTypeMap().get(this.name);
        }
        if (this.columnType == null) {
            this.columnName = columnName;
            this.insertable = insertable;
            this.updatable = updatable;
            this.quoteRequired = quoteRequired;
        } else {
            this.columnName = this.columnType.name() != null ? this.columnType.name() : columnName;
            this.insertable = this.columnType.insertable() != null ? this.columnType.insertable() : insertable;
            this.updatable = this.columnType.updatable() != null ? this.columnType.updatable() : updatable;
            this.quoteRequired = this.columnType.quote() != null ? this.columnType.quote() : quoteRequired;
        }
        this.field = new PropertyField<ENTITY>(path, entityClass);
    }

    @Override
    public Property<ENTITY, BASIC> createProperty() {
        return new DefaultProperty();
    }

    @Override
    public void copy(ENTITY destEntity, ENTITY srcEntity) {
        Property<ENTITY, BASIC> dest = this.createProperty();
        dest.load(destEntity);
        Property<ENTITY, BASIC> src = this.createProperty();
        src.load(srcEntity);
        dest.getWrapper().set(src.getWrapper().getCopy());
        dest.save(destEntity);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getColumnName() {
        return this.getColumnName(Function.identity());
    }

    @Override
    public String getColumnName(Function<String, String> quoteFunction) {
        return this.getColumnName(Naming.DEFAULT::apply, quoteFunction);
    }

    @Override
    public String getColumnName(BiFunction<NamingType, String, String> namingFunction) {
        return this.getColumnName(namingFunction, Function.identity());
    }

    @Override
    public String getColumnName(BiFunction<NamingType, String, String> namingFunction, Function<String, String> quoteFunction) {
        Object columnName = this.columnName.isEmpty() ? this.prefix + namingFunction.apply(this.namingType, this.simpleName) : (this.columnType != null ? this.columnName : this.prefix + this.columnName);
        return this.quoteRequired ? quoteFunction.apply((String)columnName) : columnName;
    }

    @Override
    public boolean isQuoteRequired() {
        return this.quoteRequired;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isVersion() {
        return false;
    }

    @Override
    public boolean isTenantId() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    protected <VALUE> ENTITY modifyIfNecessary(EntityType<ENTITY> entityType, ENTITY entity, WrapperVisitor<Boolean, VALUE, Void, RuntimeException> visitor, VALUE value) {
        if (entityType.isImmutable()) {
            List<EntityPropertyType<ENTITY, ?>> propertyTypes = entityType.getEntityPropertyTypes();
            HashMap args = new HashMap(propertyTypes.size());
            for (EntityPropertyType<ENTITY, ?> propertyType : propertyTypes) {
                Boolean modified;
                Property<ENTITY, ?> property = propertyType.createProperty();
                property.load(entity);
                if (propertyType == this && (modified = property.getWrapper().accept(visitor, value, null)) == Boolean.FALSE) {
                    return entity;
                }
                args.put(propertyType.getName(), property);
            }
            return entityType.newEntity(args);
        }
        Property<ENTITY, BASIC> property = this.createProperty();
        property.load(entity);
        Boolean modified = property.getWrapper().accept(visitor, value, null);
        if (modified == Boolean.FALSE) {
            return entity;
        }
        property.save(entity);
        return entity;
    }

    protected class DefaultProperty
    implements Property<ENTITY, BASIC> {
        protected final Scalar<BASIC, CONTAINER> scalar;

        protected DefaultProperty() {
            this.scalar = DefaultPropertyType.this.scalarSupplier.get();
        }

        @Override
        public Object get() {
            return this.scalar.get();
        }

        @Override
        public Object getAsNonOptional() {
            return this.scalar.getAsNonOptional();
        }

        @Override
        public Property<ENTITY, BASIC> load(ENTITY entity) {
            Object value = DefaultPropertyType.this.field.getValue(entity);
            this.scalar.set(this.scalar.cast(value));
            return this;
        }

        @Override
        public Property<ENTITY, BASIC> save(ENTITY entity) {
            DefaultPropertyType.this.field.setValue(entity, this.scalar.get());
            return this;
        }

        @Override
        public InParameter<BASIC> asInParameter() {
            return new ScalarInParameter(this.scalar);
        }

        @Override
        public Wrapper<BASIC> getWrapper() {
            return this.scalar.getWrapper();
        }

        @Override
        public Optional<Class<?>> getDomainClass() {
            return this.scalar.getDomainClass();
        }

        @Override
        public Optional<JdbcType<Object>> getJdbcType() {
            return this.scalar.getJdbcType();
        }

        public String toString() {
            return this.scalar.toString();
        }
    }
}

