/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.entity.PropertyField;
import org.seasar.doma.internal.jdbc.entity.PropertyPath;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public class EmbeddedPropertyType<ENTITY, EMBEDDABLE> {
    protected final PropertyPath path;
    protected final List<EntityPropertyType<ENTITY, ?>> embeddablePropertyTypes;
    protected final Map<String, EntityPropertyType<ENTITY, ?>> embeddablePropertyTypeMap;
    protected final boolean optional;
    protected final PropertyField<ENTITY> field;

    public EmbeddedPropertyType(String name, Class<ENTITY> entityClass, List<EntityPropertyType<ENTITY, ?>> embeddablePropertyType, boolean optional) {
        this(PropertyPath.of(name), entityClass, embeddablePropertyType, optional);
    }

    public EmbeddedPropertyType(PropertyPath path, Class<ENTITY> entityClass, List<EntityPropertyType<ENTITY, ?>> embeddablePropertyType, boolean optional) {
        if (path == null) {
            throw new DomaNullPointerException("path");
        }
        if (entityClass == null) {
            throw new DomaNullPointerException("entityClass");
        }
        if (embeddablePropertyType == null) {
            throw new DomaNullPointerException("embeddablePropertyType");
        }
        this.path = path;
        this.embeddablePropertyTypes = embeddablePropertyType;
        this.embeddablePropertyTypeMap = this.embeddablePropertyTypes.stream().collect(Collectors.toMap(EntityPropertyType::getName, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        this.optional = optional;
        this.field = new PropertyField<ENTITY>(path, entityClass);
    }

    public List<EntityPropertyType<ENTITY, ?>> getEmbeddablePropertyTypes() {
        return this.embeddablePropertyTypes;
    }

    public Map<String, EntityPropertyType<ENTITY, ?>> getEmbeddablePropertyTypeMap() {
        return this.embeddablePropertyTypeMap;
    }

    public void save(ENTITY entity, EMBEDDABLE value) {
        Object v = this.optional ? Optional.ofNullable(value) : value;
        this.field.setValue(entity, v);
    }
}

