/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.seasar.doma.jdbc.entity.AssociationPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.PostDeleteContext;
import org.seasar.doma.jdbc.entity.PostInsertContext;
import org.seasar.doma.jdbc.entity.PostUpdateContext;
import org.seasar.doma.jdbc.entity.PreDeleteContext;
import org.seasar.doma.jdbc.entity.PreInsertContext;
import org.seasar.doma.jdbc.entity.PreUpdateContext;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.entity.TenantIdPropertyType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public interface EntityType<ENTITY> {
    public boolean isImmutable();

    public String getName();

    public String getCatalogName();

    public String getSchemaName();

    public String getTableName(BiFunction<NamingType, String, String> var1);

    public String getQualifiedTableName(BiFunction<NamingType, String, String> var1, Function<String, String> var2);

    public boolean isQuoteRequired();

    public NamingType getNamingType();

    public GeneratedIdPropertyType<ENTITY, ?, ?> getGeneratedIdPropertyType();

    public VersionPropertyType<ENTITY, ?, ?> getVersionPropertyType();

    public TenantIdPropertyType<ENTITY, ?, ?> getTenantIdPropertyType();

    public List<EntityPropertyType<ENTITY, ?>> getIdPropertyTypes();

    public EntityPropertyType<ENTITY, ?> getEntityPropertyType(String var1);

    public List<EntityPropertyType<ENTITY, ?>> getEntityPropertyTypes();

    default public List<AssociationPropertyType> getAssociationPropertyTypes() {
        return Collections.emptyList();
    }

    public ENTITY newEntity(Map<String, Property<ENTITY, ?>> var1);

    public Class<ENTITY> getEntityClass();

    public void saveCurrentStates(ENTITY var1);

    public ENTITY getOriginalStates(ENTITY var1);

    public void preInsert(ENTITY var1, PreInsertContext<ENTITY> var2);

    public void preUpdate(ENTITY var1, PreUpdateContext<ENTITY> var2);

    public void preDelete(ENTITY var1, PreDeleteContext<ENTITY> var2);

    public void postInsert(ENTITY var1, PostInsertContext<ENTITY> var2);

    public void postUpdate(ENTITY var1, PostUpdateContext<ENTITY> var2);

    public void postDelete(ENTITY var1, PostDeleteContext<ENTITY> var2);
}

