/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.StringUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NamingType {
    NONE{

        @Override
        public String apply(String text) {
            return text;
        }

        @Override
        public String revert(String text) {
            return text;
        }
    }
    ,
    SNAKE_UPPER_CASE{

        @Override
        public String apply(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            String s = StringUtil.fromCamelCaseToSnakeCase(text);
            return s.toUpperCase();
        }

        @Override
        public String revert(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            return StringUtil.fromSnakeCaseToCamelCase(text);
        }
    }
    ,
    SNAKE_LOWER_CASE{

        @Override
        public String apply(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            String s = StringUtil.fromCamelCaseToSnakeCase(text);
            return s.toLowerCase();
        }

        @Override
        public String revert(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            return StringUtil.fromSnakeCaseToCamelCase(text);
        }
    }
    ,
    UPPER_CASE{

        @Override
        public String apply(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            return text.toUpperCase();
        }

        @Override
        public String revert(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            return text.toLowerCase();
        }
    }
    ,
    LOWER_CASE{

        @Override
        public String apply(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            return text.toLowerCase();
        }

        @Override
        public String revert(String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            return text;
        }
    };


    public abstract String apply(String var1);

    public abstract String revert(String var1);
}

