/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.seasar.doma.jdbc.id.AbstractIdGenerator;
import org.seasar.doma.jdbc.id.IdGenerationConfig;

public abstract class AbstractPreGenerateIdGenerator
extends AbstractIdGenerator {
    protected long initialValue;
    protected long allocationSize;
    protected final ConcurrentMap<String, IdContext> idContextMap = new ConcurrentHashMap<String, IdContext>();

    public void setInitialValue(long initialValue) {
        this.initialValue = initialValue;
    }

    public void setAllocationSize(long allocationSize) {
        this.allocationSize = allocationSize;
    }

    @Override
    public boolean supportsBatch(IdGenerationConfig config) {
        return true;
    }

    @Override
    public boolean supportsAutoGeneratedKeys(IdGenerationConfig config) {
        return false;
    }

    @Override
    public boolean includesIdentityColumn(IdGenerationConfig config) {
        return true;
    }

    @Override
    public boolean includesIdentityColumn(IdGenerationConfig config, Object idValue) {
        return true;
    }

    @Override
    public Long generatePreInsert(IdGenerationConfig config) {
        IdContext idContext = this.getIdContext(config);
        return idContext.getNextValue(config);
    }

    @Override
    public List<Long> generateValuesPreInsert(IdGenerationConfig config, int count) {
        IdContext idContext = this.getIdContext(config);
        ArrayList<Long> values = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            long value = idContext.getNextValue(config);
            values.add(value);
        }
        return values;
    }

    @Override
    public Long generatePostInsert(IdGenerationConfig config, Statement statement) {
        return null;
    }

    protected IdContext getIdContext(IdGenerationConfig config) {
        String dataSourceName = config.getDataSourceName();
        IdContext context = (IdContext)this.idContextMap.get(dataSourceName);
        if (context != null) {
            return context;
        }
        context = new IdContext();
        IdContext existent = this.idContextMap.putIfAbsent(dataSourceName, context);
        if (existent != null) {
            return existent;
        }
        return context;
    }

    protected abstract long getNewInitialValue(IdGenerationConfig var1);

    public class IdContext {
        protected long initValue;
        protected long allocated;

        public IdContext() {
            this.initValue = AbstractPreGenerateIdGenerator.this.initialValue;
            this.allocated = Long.MAX_VALUE;
        }

        public synchronized long getNextValue(IdGenerationConfig config) {
            if (this.allocated < AbstractPreGenerateIdGenerator.this.allocationSize) {
                return this.initValue + this.allocated++;
            }
            this.initValue = AbstractPreGenerateIdGenerator.this.getNewInitialValue(config);
            this.allocated = 1L;
            return this.initValue;
        }
    }
}

