/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.GenerationType;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.id.AbstractIdGenerator;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.id.IdentityIdGenerator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class BuiltinIdentityIdGenerator
extends AbstractIdGenerator
implements IdentityIdGenerator {
    @Override
    public boolean supportsBatch(IdGenerationConfig config) {
        return config.getDialect().supportsBatchExecutionReturningGeneratedValues();
    }

    @Override
    public boolean includesIdentityColumn(IdGenerationConfig config) {
        return config.getDialect().includesIdentityColumn();
    }

    @Override
    public boolean includesIdentityColumn(IdGenerationConfig config, Object idValue) {
        return config.getDialect().includesIdentityColumn(idValue);
    }

    @Override
    public boolean supportsAutoGeneratedKeys(IdGenerationConfig config) {
        return config.getDialect().supportsAutoGeneratedKeys();
    }

    @Override
    public Long generatePreInsert(IdGenerationConfig config) {
        return null;
    }

    @Override
    public Long generatePostInsert(IdGenerationConfig config, Statement statement) {
        if (config.getDialect().supportsAutoGeneratedKeys()) {
            return this.getGeneratedValue(config, statement);
        }
        return this.getGeneratedValue(config);
    }

    protected long getGeneratedValue(IdGenerationConfig config, Statement statement) {
        try {
            ResultSet resultSet = statement.getGeneratedKeys();
            return this.getGeneratedValue(config, resultSet);
        }
        catch (SQLException e) {
            throw new JdbcException((MessageResource)Message.DOMA2018, (Throwable)e, config.getEntityType().getName(), e);
        }
    }

    protected long getGeneratedValue(IdGenerationConfig config) {
        Naming naming = config.getNaming();
        EntityType<?> entityType = config.getEntityType();
        String catalogName = entityType.getCatalogName();
        String schemaName = entityType.getSchemaName();
        String tableName = entityType.getTableName(naming::apply);
        String idColumnName = entityType.getGeneratedIdPropertyType().getColumnName(naming::apply);
        Sql<?> sql = config.getDialect().getIdentitySelectSql(catalogName, schemaName, tableName, idColumnName, entityType.isQuoteRequired(), entityType.getGeneratedIdPropertyType().isQuoteRequired());
        return this.getGeneratedValue(config, sql);
    }

    @Override
    public List<Long> generateValuesPostInsert(IdGenerationConfig config, Statement statement) {
        JdbcLogger logger = config.getJdbcLogger();
        ArrayList<Long> values = new ArrayList<Long>();
        ResultSet resultSet = null;
        try {
            resultSet = statement.getGeneratedKeys();
            while (resultSet.next()) {
                long value = resultSet.getLong(1);
                values.add(value);
            }
        }
        catch (SQLException e) {
            throw new JdbcException((MessageResource)Message.DOMA2018, (Throwable)e, config.getEntityType().getName(), e);
        }
        finally {
            JdbcUtil.close(resultSet, logger);
        }
        return values;
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.IDENTITY;
    }
}

