/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.id.IdProvider;
import org.seasar.doma.jdbc.statistic.StatisticManager;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

@Deprecated
public class ReservedIdProvider
implements IdProvider {
    protected final Config config;
    protected final EntityType<?> entityType;
    protected final int reservationSize;
    protected final boolean available;
    protected long[] identities;
    protected int index = 0;

    public ReservedIdProvider(Config config, EntityType<?> entityType, int reservationSize) {
        AssertionUtil.assertNotNull((Object)config, entityType);
        this.config = config;
        this.entityType = entityType;
        this.reservationSize = reservationSize;
        this.available = config.getDialect().supportsIdentityReservation();
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public long get() {
        if (!this.available) {
            throw new UnsupportedOperationException();
        }
        if (this.identities == null) {
            this.identities = this.getIdentities();
        }
        if (this.identities.length <= this.index) {
            throw new IllegalStateException(String.format("identities.length=%d, index=%d", this.identities.length, this.index));
        }
        return this.identities[this.index++];
    }

    /*
     * Loose catch block
     */
    protected long[] getIdentities() {
        Sql<?> sql = this.createSql();
        JdbcLogger logger = this.config.getJdbcLogger();
        StatisticManager statisticManager = this.config.getStatisticManager();
        Connection connection = JdbcUtil.getConnection(this.config.getDataSource());
        try {
            PreparedStatement preparedStatement = JdbcUtil.prepareStatement(connection, sql);
            try {
                logger.logSql(this.getClass().getName(), "getIdentities", sql);
                this.setupOptions(preparedStatement);
                long[] lArray = statisticManager.executeSql(sql, () -> {
                    long[] identities = new long[this.reservationSize];
                    ResultSet resultSet = preparedStatement.executeQuery();
                    try {
                        for (int i = 0; i < this.reservationSize && resultSet.next(); ++i) {
                            identities[i] = resultSet.getLong(1);
                        }
                    }
                    catch (SQLException e) {
                        throw new JdbcException((MessageResource)Message.DOMA2083, (Throwable)e, this.entityType.getName(), e);
                    }
                    finally {
                        JdbcUtil.close(resultSet, logger);
                    }
                    return identities;
                });
                return lArray;
            }
            catch (SQLException e) {
                throw new JdbcException((MessageResource)Message.DOMA2083, (Throwable)e, this.entityType.getName(), e);
            }
            finally {
                JdbcUtil.close(preparedStatement, logger);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JdbcUtil.close(connection, logger);
        }
    }

    protected Sql<?> createSql() {
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        String catalogName = this.entityType.getCatalogName();
        String schemaName = this.entityType.getSchemaName();
        String tableName = this.entityType.getTableName(naming::apply);
        String idColumnName = this.entityType.getGeneratedIdPropertyType().getColumnName(naming::apply);
        boolean isQuoteRequired = this.entityType.isQuoteRequired();
        boolean isIdColumnQuoteRequired = this.entityType.getGeneratedIdPropertyType().isQuoteRequired();
        return dialect.getIdentityReservationSql(catalogName, schemaName, tableName, idColumnName, isQuoteRequired, isIdColumnQuoteRequired, this.reservationSize);
    }

    protected void setupOptions(PreparedStatement preparedStatement) throws SQLException {
        if (this.config.getFetchSize() > 0) {
            preparedStatement.setFetchSize(this.config.getFetchSize());
        }
        if (this.config.getMaxRows() > 0) {
            preparedStatement.setMaxRows(this.config.getMaxRows());
        }
        if (this.config.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(this.config.getQueryTimeout());
        }
    }
}

