/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.CommentContext;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.query.Query;

public abstract class AbstractQuery
implements Query {
    protected String callerClassName;
    protected String callerMethodName;
    protected Config config;
    protected Method method;
    protected int queryTimeout;
    protected String message;
    private CommentContext commentContext;

    protected AbstractQuery() {
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.callerClassName, (Object)this.callerMethodName, (Object)this.config);
        this.commentContext = new CommentContext(this.callerClassName, this.callerMethodName, this.config, this.method, this.message);
    }

    @Override
    public String comment(String sql) {
        AssertionUtil.assertNotNull((Object)sql, (Object)this.config, (Object)this.commentContext);
        return this.config.getCommenter().comment(sql, this.commentContext);
    }
}

