/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.seasar.doma.DomaException;
import org.seasar.doma.FetchType;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.command.BasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.sql.SqlContext;
import org.seasar.doma.internal.jdbc.sql.node.ExpandNode;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.SelectOptionsAccessor;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.aggregate.AggregateStrategyType;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.CountQuery;
import org.seasar.doma.jdbc.query.SelectQuery;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;
import org.seasar.doma.wrapper.PrimitiveLongWrapper;

public abstract class AbstractSelectQuery
extends AbstractQuery
implements SelectQuery {
    protected final Map<String, Value> parameters = new HashMap<String, Value>();
    protected SelectOptions options = SelectOptions.get();
    protected boolean resultEnsured;
    protected boolean resultMappingEnsured;
    protected FetchType fetchType;
    protected int fetchSize;
    protected int maxRows;
    protected EntityType<?> entityType;
    protected PreparedSql sql;
    protected SqlLogType sqlLogType;
    protected boolean resultStream;
    protected AggregateStrategyType aggregateStrategyType;

    protected AbstractSelectQuery() {
    }

    @Override
    public void prepare() {
        super.prepare();
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void prepareOptions() {
        if (this.fetchSize <= 0) {
            this.fetchSize = this.config.getFetchSize();
        }
        if (this.maxRows <= 0) {
            this.maxRows = this.config.getMaxRows();
        }
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    protected abstract void prepareSql();

    @Deprecated(forRemoval=true)
    protected void buildSql(BiFunction<ExpressionEvaluator, Function<ExpandNode, List<String>>, PreparedSql> sqlBuilder) {
        ExpressionEvaluator evaluator = this.createExpressionEvaluator();
        this.sql = sqlBuilder.apply(evaluator, this::expandColumns);
    }

    protected ExpressionEvaluator createExpressionEvaluator() {
        return new ExpressionEvaluator(this.parameters, this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
    }

    protected List<String> expandColumns(ExpandNode node) {
        if (this.entityType == null) {
            SqlLocation location = node.getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2144, location.getSql(), location.getLineNumber(), location.getPosition());
        }
        if (this.aggregateStrategyType != null) {
            return List.of();
        }
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        return this.entityType.getEntityPropertyTypes().stream().map(p -> p.getColumnName(naming::apply, dialect::applyQuote)).collect(Collectors.toList());
    }

    protected List<String> expandAggregateColumns(ExpandNode node, String aliasCsv) {
        if (this.entityType == null) {
            SqlLocation location = node.getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2144, location.getSql(), location.getLineNumber(), location.getPosition());
        }
        if (this.aggregateStrategyType == null) {
            return List.of();
        }
        HashSet<String> definedAliases = new HashSet<String>(this.aggregateStrategyType.getTableAliases());
        Set requiredAliases = Arrays.stream(aliasCsv.split(",")).map(String::trim).filter(s -> !s.isEmpty()).peek(s -> {
            if (!definedAliases.contains(s)) {
                throw new DomaException((MessageResource)Message.DOMA2239, s, this.aggregateStrategyType.getName());
            }
        }).collect(Collectors.toSet());
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        Stream<Pair<String, EntityType<?>>> rootStream = Stream.of(new Pair(this.aggregateStrategyType.getTableAlias(), this.aggregateStrategyType.getRoot()));
        Stream<Pair> associationStream = this.aggregateStrategyType.getAssociationLinkerTypes().stream().map(it -> new Pair(it.getTableAlias(), it.getTarget()));
        return Stream.concat(rootStream, associationStream).filter(pair -> requiredAliases.isEmpty() || requiredAliases.contains(pair.fst)).flatMap(pair -> ((EntityType)pair.snd).getEntityPropertyTypes().stream().map(it -> new Pair<String, EntityPropertyType>((String)pair.fst, (EntityPropertyType)it))).map(pair -> {
            String tableAlias = (String)pair.fst;
            String columnName = ((EntityPropertyType)pair.snd).getColumnName(naming::apply, dialect::applyQuote);
            return String.format("%1$s.%2$s as %1$s_%2$s", tableAlias, columnName);
        }).toList();
    }

    protected void populateValues(PopulateNode node, SqlContext context) {
        throw new UnsupportedOperationException();
    }

    protected void executeCount(SqlNode sqlNode) {
        CountQuery query = new CountQuery();
        query.setCallerClassName(this.callerClassName);
        query.setCallerMethodName(this.callerMethodName);
        query.setMethod(this.method);
        query.setConfig(this.config);
        query.setFetchSize(this.fetchSize);
        query.setMaxRows(this.maxRows);
        query.setQueryTimeout(this.queryTimeout);
        query.setOptions(this.options);
        query.setSqlNode(sqlNode);
        query.setEntityType(this.entityType);
        query.setSqlLogType(this.sqlLogType);
        query.addParameters(this.parameters);
        query.prepare();
        SelectCommand command = new SelectCommand(query, new BasicSingleResultHandler(PrimitiveLongWrapper::new));
        long count = (Long)command.execute();
        query.complete();
        SelectOptionsAccessor.setCountSize(this.options, count);
    }

    @Override
    public SelectOptions getOptions() {
        return this.options;
    }

    public void setOptions(SelectOptions options) {
        this.options = options;
    }

    public void addParameter(String name, Class<?> type, Object value) {
        AssertionUtil.assertNotNull((Object)name, type);
        this.parameters.put(name, new Value(type, value));
    }

    public void addParameters(Map<String, Value> parameters) {
        this.parameters.putAll(parameters);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    @Override
    public boolean isResultEnsured() {
        return this.resultEnsured;
    }

    public void setResultEnsured(boolean resultEnsured) {
        this.resultEnsured = resultEnsured;
    }

    @Override
    public boolean isResultMappingEnsured() {
        return this.resultMappingEnsured;
    }

    public void setResultMappingEnsured(boolean resultMappingEnsured) {
        this.resultMappingEnsured = resultMappingEnsured;
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(FetchType fetchType) {
        this.fetchType = fetchType;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    @Override
    public boolean isResultStream() {
        return this.resultStream;
    }

    public void setResultStream(boolean resultStream) {
        this.resultStream = resultStream;
    }

    public void setAggregateStrategyType(AggregateStrategyType aggregateStrategyType) {
        this.aggregateStrategyType = aggregateStrategyType;
    }

    public void setEntityType(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    public String toString() {
        return this.sql != null ? this.sql.toString() : null;
    }
}

