/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.util.Objects;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoModifyQuery;
import org.seasar.doma.jdbc.query.DeleteAssembler;
import org.seasar.doma.jdbc.query.DeleteAssemblerContext;
import org.seasar.doma.jdbc.query.DeleteAssemblerContextBuilder;
import org.seasar.doma.jdbc.query.DeleteQuery;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class AutoDeleteQuery<ENTITY>
extends AutoModifyQuery<ENTITY>
implements DeleteQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public AutoDeleteQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entityType);
        this.executable = true;
        this.preDelete();
        this.prepareSpecialPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preDelete() {
        AutoPreDeleteContext context = new AutoPreDeleteContext(this.entityType, this.method, this.config, this.returning);
        this.entityType.preDelete(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareSql() {
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.DELETE, this.sqlLogType);
        DeleteAssemblerContext<Object> assemblerContext = DeleteAssemblerContextBuilder.build(builder, this.entityType, this.config.getNaming(), dialect, this.idPropertyTypes, this.versionPropertyType, this.tenantIdPropertyType, this.versionIgnored, this.entity, this.returning);
        DeleteAssembler deleteAssembler = dialect.getDeleteAssembler(assemblerContext);
        deleteAssembler.assemble();
        this.sql = builder.build(this::comment);
    }

    @Override
    public void complete() {
        this.postDelete();
    }

    protected void postDelete() {
        AutoPostDeleteContext context = new AutoPostDeleteContext(this.entityType, this.method, this.config, this.returning);
        this.entityType.postDelete(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoPreDeleteContext<E>
    extends AbstractPreDeleteContext<E> {
        private final ReturningProperties returningProperties;

        public AutoPreDeleteContext(EntityType<E> entityType, Method method, Config config, ReturningProperties returningProperties) {
            super(entityType, method, config);
            this.returningProperties = Objects.requireNonNull(returningProperties);
        }

        @Override
        public ReturningProperties getReturningProperties() {
            return this.returningProperties;
        }
    }

    protected static class AutoPostDeleteContext<E>
    extends AbstractPostDeleteContext<E> {
        private final ReturningProperties returningProperties;

        public AutoPostDeleteContext(EntityType<E> entityType, Method method, Config config, ReturningProperties returningProperties) {
            super(entityType, method, config);
            this.returningProperties = Objects.requireNonNull(returningProperties);
        }

        @Override
        public ReturningProperties getReturningProperties() {
            return this.returningProperties;
        }
    }
}

