/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.List;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.TenantIdPropertyType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.ModifyQuery;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AutoModifyQuery<ENTITY>
extends AbstractQuery
implements ModifyQuery {
    protected static final String[] EMPTY_STRINGS = new String[0];
    protected String[] includedPropertyNames = EMPTY_STRINGS;
    protected String[] excludedPropertyNames = EMPTY_STRINGS;
    protected final EntityType<ENTITY> entityType;
    protected ENTITY entity;
    protected PreparedSql sql;
    protected List<EntityPropertyType<ENTITY, ?>> targetPropertyTypes;
    protected List<EntityPropertyType<ENTITY, ?>> idPropertyTypes;
    protected VersionPropertyType<ENTITY, ?, ?> versionPropertyType;
    protected TenantIdPropertyType<ENTITY, ?, ?> tenantIdPropertyType;
    protected boolean optimisticLockCheckRequired;
    protected boolean autoGeneratedKeysSupported;
    protected boolean executable;
    protected SqlExecutionSkipCause sqlExecutionSkipCause = SqlExecutionSkipCause.STATE_UNCHANGED;
    protected SqlLogType sqlLogType;
    protected ReturningProperties returning = ReturningProperties.NONE;

    protected AutoModifyQuery(EntityType<ENTITY> entityType) {
        AssertionUtil.assertNotNull(entityType);
        this.entityType = entityType;
    }

    @Override
    public void prepare() {
        super.prepare();
        if (!this.returning.isNone() && !this.config.getDialect().supportsReturning()) {
            throw new JdbcException((MessageResource)Message.DOMA2240, this.config.getDialect().getName());
        }
    }

    protected void prepareSpecialPropertyTypes() {
        this.idPropertyTypes = this.entityType.getIdPropertyTypes();
        this.versionPropertyType = this.entityType.getVersionPropertyType();
        this.tenantIdPropertyType = this.entityType.getTenantIdPropertyType();
    }

    protected void validateIdExistent() {
        if (this.idPropertyTypes.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2022, this.entityType.getName());
        }
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    protected boolean isTargetPropertyName(String name) {
        if (this.includedPropertyNames.length > 0) {
            for (String includedName : this.includedPropertyNames) {
                if (!includedName.equals(name)) continue;
                for (String excludedName : this.excludedPropertyNames) {
                    if (!excludedName.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludedPropertyNames.length > 0) {
            for (String excludedName : this.excludedPropertyNames) {
                if (!excludedName.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void setEntity(ENTITY entity) {
        this.entity = entity;
    }

    public ENTITY getEntity() {
        return this.entity;
    }

    public void setIncludedPropertyNames(String ... includedPropertyNames) {
        this.includedPropertyNames = includedPropertyNames;
    }

    public void setExcludedPropertyNames(String ... excludedPropertyNames) {
        this.excludedPropertyNames = excludedPropertyNames;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    public void setReturning(ReturningProperties returning) {
        this.returning = returning;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return this.sqlExecutionSkipCause;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return this.autoGeneratedKeysSupported;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }

    public String toString() {
        return this.sql != null ? this.sql.toString() : null;
    }
}

