/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.util.DatabaseObjectUtil;
import org.seasar.doma.jdbc.CallableSql;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlParameter;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.ModuleQuery;

public abstract class AutoModuleQuery
extends AbstractQuery
implements ModuleQuery {
    protected CallableSql sql;
    protected String catalogName;
    protected String schemaName;
    protected String moduleName;
    protected String qualifiedName;
    protected boolean isQuoteRequired;
    protected final List<SqlParameter> parameters = new ArrayList<SqlParameter>();
    protected SqlLogType sqlLogType;

    protected void prepareQualifiedName() {
        Function<String, String> mapper = this.isQuoteRequired ? this.config.getDialect()::applyQuote : Function.identity();
        this.qualifiedName = DatabaseObjectUtil.getQualifiedName(mapper, this.catalogName, this.schemaName, this.moduleName);
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    @Override
    public void complete() {
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    protected void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setQuoteRequired(boolean isQuoteRequired) {
        this.isQuoteRequired = isQuoteRequired;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    public void addParameter(SqlParameter parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public CallableSql getSql() {
        return this.sql;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }
}

