/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.seasar.doma.GenerationType;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.query.AutoModifyQuery;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.InsertQuery;
import org.seasar.doma.jdbc.query.MultiInsertAssembler;
import org.seasar.doma.jdbc.query.MultiInsertAssemblerContext;
import org.seasar.doma.jdbc.query.MultiInsertAssemblerContextBuilder;
import org.seasar.doma.jdbc.query.QueryUtil;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssemblerContextBuilder;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoMultiInsertQuery<ENTITY>
extends AutoModifyQuery<ENTITY>
implements InsertQuery {
    protected List<ENTITY> entities;
    protected GeneratedIdPropertyType<ENTITY, ?, ?> generatedIdPropertyType;
    protected IdGenerationConfig idGenerationConfig;
    protected DuplicateKeyType duplicateKeyType = DuplicateKeyType.EXCEPTION;
    protected String[] duplicateKeyNames = EMPTY_STRINGS;

    public AutoMultiInsertQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entityType, this.entities);
        Dialect dialect = this.config.getDialect();
        if (!dialect.supportsMultiRowInsertStatement()) {
            throw new JdbcException((MessageResource)Message.DOMA2236, dialect.getName());
        }
        if (this.entities.isEmpty()) {
            this.sqlExecutionSkipCause = SqlExecutionSkipCause.MULTI_INSERT_TARGET_NONEXISTENT;
            return;
        }
        this.executable = true;
        this.entity = this.entities.stream().findFirst().orElseThrow(IllegalStateException::new);
        this.preInsert();
        this.prepareSpecialPropertyTypes();
        this.prepareOptions();
        this.prepareTargetPropertyType();
        this.prepareIdValue();
        this.prepareVersionValue();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preInsert() {
        ListIterator<ENTITY> iterator = this.entities.listIterator();
        while (iterator.hasNext()) {
            ENTITY entity = iterator.next();
            AutoPreInsertContext context = new AutoPreInsertContext(this.entityType, this.method, this.config, this.duplicateKeyType, this.returning);
            this.entityType.preInsert(entity, context);
            Object newEntity = context.getNewEntity();
            if (newEntity == null) continue;
            iterator.set(newEntity);
        }
    }

    @Override
    protected void prepareSpecialPropertyTypes() {
        super.prepareSpecialPropertyTypes();
        this.generatedIdPropertyType = this.entityType.getGeneratedIdPropertyType();
        if (this.generatedIdPropertyType != null) {
            GenerationType generationType = this.generatedIdPropertyType.getGenerationType();
            Dialect dialect = this.config.getDialect();
            if (generationType == GenerationType.IDENTITY && !dialect.supportsAutoIncrementWhenInsertingMultipleRows()) {
                throw new JdbcException((MessageResource)Message.DOMA2235, dialect.getName());
            }
            this.idGenerationConfig = new IdGenerationConfig(this.config, this.entityType);
            this.generatedIdPropertyType.validateGenerationStrategy(this.idGenerationConfig);
            this.autoGeneratedKeysSupported = this.generatedIdPropertyType.isAutoGeneratedKeysSupported(this.idGenerationConfig);
        }
    }

    protected void prepareTargetPropertyType() {
        this.targetPropertyTypes = new ArrayList(this.entityType.getEntityPropertyTypes().size());
        for (EntityPropertyType propertyType : this.entityType.getEntityPropertyTypes()) {
            if (!propertyType.isInsertable()) continue;
            Property<Object, ?> property = propertyType.createProperty();
            property.load(this.entity);
            if (propertyType.isId()) {
                if (propertyType != this.generatedIdPropertyType || this.generatedIdPropertyType.isIncluded(this.idGenerationConfig, property.getWrapper().get())) {
                    this.targetPropertyTypes.add(propertyType);
                }
                if (this.generatedIdPropertyType != null || property.getWrapper().get() != null) continue;
                throw new JdbcException((MessageResource)Message.DOMA2020, this.entityType.getName(), propertyType.getName());
            }
            if (propertyType.isVersion()) {
                this.targetPropertyTypes.add(propertyType);
                continue;
            }
            if (!this.isTargetPropertyName(propertyType.getName())) continue;
            this.targetPropertyTypes.add(propertyType);
        }
    }

    protected void prepareIdValue() {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            List<ENTITY> newEntities = this.generatedIdPropertyType.preInsert(this.entityType, this.entities, this.idGenerationConfig);
            if (this.entities.size() == newEntities.size()) {
                this.entities = newEntities;
            }
        }
    }

    protected void prepareVersionValue() {
        if (this.versionPropertyType != null) {
            ListIterator<ENTITY> iterator = this.entities.listIterator();
            while (iterator.hasNext()) {
                ENTITY entity = iterator.next();
                ENTITY newEntity = this.versionPropertyType.setIfNecessary(this.entityType, entity, 1);
                iterator.set(newEntity);
            }
        }
    }

    protected void prepareSql() {
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.MULTI_INSERT, this.sqlLogType);
        if (this.duplicateKeyType == DuplicateKeyType.EXCEPTION) {
            this.assembleInsertSql(builder, naming, dialect);
        } else if (dialect.supportsUpsertEmulationWithMergeStatement() && QueryUtil.isIdentityKeyIncludedInDuplicateKeys(this.generatedIdPropertyType, this.duplicateKeyNames)) {
            this.assembleInsertSql(builder, naming, dialect);
        } else {
            this.assembleUpsertSql(builder, naming, dialect);
        }
        this.sql = builder.build(this::comment);
    }

    private void assembleInsertSql(PreparedSqlBuilder builder, Naming naming, Dialect dialect) {
        MultiInsertAssemblerContext<ENTITY> context = MultiInsertAssemblerContextBuilder.buildFromEntityList(builder, this.entityType, naming, dialect, this.targetPropertyTypes, this.entities, this.returning);
        MultiInsertAssembler assembler = dialect.getMultiInsertAssembler(context);
        assembler.assemble();
    }

    private void assembleUpsertSql(PreparedSqlBuilder builder, Naming naming, Dialect dialect) {
        List duplicateKeys = Arrays.stream(this.duplicateKeyNames).map(this.entityType::getEntityPropertyType).filter(Objects::nonNull).collect(Collectors.toList());
        UpsertAssemblerContext context = UpsertAssemblerContextBuilder.buildFromEntityList(builder, this.entityType, this.duplicateKeyType, duplicateKeys, naming, dialect, this.idPropertyTypes, this.targetPropertyTypes, this.entities, this.returning);
        UpsertAssembler assembler = dialect.getUpsertAssembler(context);
        assembler.assemble();
    }

    @Override
    public void generateId(Statement statement) {
        if (this.isAutoGeneratedKeysSupported()) {
            List<ENTITY> newEntities = this.generatedIdPropertyType.postInsert(this.entityType, this.entities, this.idGenerationConfig, statement);
            if (this.entities.size() == newEntities.size()) {
                this.entities = newEntities;
            }
        }
    }

    @Override
    public void complete() {
        this.postInsert();
    }

    protected void postInsert() {
        ListIterator<ENTITY> iterator = this.entities.listIterator();
        while (iterator.hasNext()) {
            ENTITY entity = iterator.next();
            AutoPostInsertContext context = new AutoPostInsertContext(this.entityType, this.method, this.config, this.duplicateKeyType, this.returning);
            this.entityType.postInsert(entity, context);
            Object newEntity = context.getNewEntity();
            if (newEntity == null) continue;
            iterator.set(newEntity);
        }
    }

    public void setDuplicateKeyType(DuplicateKeyType duplicateKeyType) {
        this.duplicateKeyType = duplicateKeyType;
    }

    public void setDuplicateKeyNames(String ... duplicateKeyNames) {
        this.duplicateKeyNames = duplicateKeyNames;
    }

    public void setEntities(List<ENTITY> entities) {
        if (entities != null) {
            this.entities = new ArrayList<ENTITY>(entities);
        }
    }

    public List<ENTITY> getEntities() {
        return this.entities;
    }

    @Override
    public void setEntity(ENTITY entity) {
        throw new UnsupportedOperationException("Use the setEntities method instead.");
    }

    @Override
    public ENTITY getEntity() {
        throw new UnsupportedOperationException("Use the getEntities method instead.");
    }

    protected static class AutoPreInsertContext<E>
    extends AbstractPreInsertContext<E> {
        private final ReturningProperties returningProperties;

        public AutoPreInsertContext(EntityType<E> entityType, Method method, Config config, DuplicateKeyType duplicateKeyType, ReturningProperties returningProperties) {
            super(entityType, method, config, duplicateKeyType);
            this.returningProperties = Objects.requireNonNull(returningProperties);
        }

        @Override
        public ReturningProperties getReturningProperties() {
            return this.returningProperties;
        }
    }

    protected static class AutoPostInsertContext<E>
    extends AbstractPostInsertContext<E> {
        private final ReturningProperties returningProperties;

        public AutoPostInsertContext(EntityType<E> entityType, Method method, Config config, DuplicateKeyType duplicateKeyType, ReturningProperties returningProperties) {
            super(entityType, method, config, duplicateKeyType);
            this.returningProperties = Objects.requireNonNull(returningProperties);
        }

        @Override
        public ReturningProperties getReturningProperties() {
            return this.returningProperties;
        }
    }
}

