/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.Objects;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public interface QueryOperand {
    public EntityPropertyType<?, ?> getEntityPropertyType();

    public void accept(Visitor var1);

    public static interface Visitor {
        public void visit(Param var1);

        public void visit(Prop var1);
    }

    public static final class Prop
    implements QueryOperand {
        public final EntityPropertyType<?, ?> propertyType;

        public Prop(EntityPropertyType<?, ?> propertyType) {
            this.propertyType = Objects.requireNonNull(propertyType);
        }

        @Override
        public EntityPropertyType<?, ?> getEntityPropertyType() {
            return this.propertyType;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static final class Param
    implements QueryOperand {
        public final EntityPropertyType<?, ?> propertyType;
        public final InParameter<?> inParameter;

        public Param(EntityPropertyType<?, ?> propertyType, InParameter<?> inParameter) {
            this.propertyType = Objects.requireNonNull(propertyType);
            this.inParameter = Objects.requireNonNull(inParameter);
        }

        @Override
        public EntityPropertyType<?, ?> getEntityPropertyType() {
            return this.propertyType;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }
}

