/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class ReturningPropertyNames
implements ReturningProperties {
    private final List<String> includedNames;
    private final List<String> excludedNames;

    private ReturningPropertyNames(List<String> includedNames, List<String> excludedNames) {
        this.includedNames = Objects.requireNonNull(includedNames);
        this.excludedNames = Objects.requireNonNull(excludedNames);
    }

    @Override
    public List<? extends EntityPropertyType<?, ?>> resolve(EntityType<?> entityType) {
        Objects.requireNonNull(entityType);
        List<EntityPropertyType<?, ?>> includedPropertyTypes = this.extractIncludedPropertyTypes(entityType);
        List<? extends EntityPropertyType<?, ?>> excludedPropertyTypes = this.extractExcludedPropertyTypes(entityType);
        return includedPropertyTypes.stream().filter(it -> !excludedPropertyTypes.contains(it)).toList();
    }

    private List<? extends EntityPropertyType<?, ?>> extractIncludedPropertyTypes(EntityType<?> entityType) {
        List<EntityPropertyType> list = this.includedNames.stream().map(entityType::getEntityPropertyType).toList();
        return list.isEmpty() ? entityType.getEntityPropertyTypes() : list;
    }

    private List<? extends EntityPropertyType<?, ?>> extractExcludedPropertyTypes(EntityType<?> entityType) {
        return this.excludedNames.stream().map(entityType::getEntityPropertyType).toList();
    }

    public static ReturningProperties of(List<String> includedNames, List<String> excludedNames) {
        if (includedNames.isEmpty() && excludedNames.isEmpty()) {
            return ALL;
        }
        return new ReturningPropertyNames(includedNames, excludedNames);
    }
}

