/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.BatchModifyQuery;

public abstract class SqlBatchModifyQuery
extends AbstractQuery
implements BatchModifyQuery {
    protected final SqlKind kind;
    protected SqlNode sqlNode;
    protected final Map<String, List<Value>> parameters = new LinkedHashMap<String, List<Value>>();
    protected List<PreparedSql> sqls;
    protected boolean optimisticLockCheckRequired;
    protected int batchSize = -1;
    protected SqlLogType sqlLogType;
    protected int parameterSize = -1;

    protected SqlBatchModifyQuery(SqlKind kind) {
        AssertionUtil.assertNotNull((Object)kind);
        this.kind = kind;
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull(this.sqlNode);
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sqls);
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
        if (this.batchSize <= 0) {
            this.batchSize = this.config.getBatchSize();
        }
    }

    protected void prepareSql() {
        this.sqls = new ArrayList<PreparedSql>();
        IntStream.rangeClosed(0, this.parameterSize - 1).forEach(i -> {
            LinkedHashMap<String, Value> map = new LinkedHashMap<String, Value>(){
                {
                    SqlBatchModifyQuery.this.parameters.forEach((key, value) -> this.put(key, (Value)value.get(i)));
                }
            };
            ExpressionEvaluator evaluator = new ExpressionEvaluator((Map<String, Value>)map, this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
            NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, this.kind, null, evaluator, this.sqlLogType);
            PreparedSql sql = sqlBuilder.build(this.sqlNode, this::comment);
            this.sqls.add(sql);
        });
    }

    @Override
    public void complete() {
    }

    public void setSqlNode(SqlNode sqlNode) {
        this.sqlNode = sqlNode;
    }

    public void addParameter(String name, Class<?> type, List<?> values) {
        AssertionUtil.assertNotNull((Object)name, type);
        AssertionUtil.assertNotNull(values);
        ArrayList<Value> valueList = new ArrayList<Value>();
        for (Object value : values) {
            valueList.add(new Value(type, value));
        }
        if (this.parameterSize == -1) {
            this.parameterSize = valueList.size();
        } else {
            AssertionUtil.assertEquals(this.parameterSize, valueList.size());
        }
        this.parameters.put(name, valueList);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    @Override
    public PreparedSql getSql() {
        return this.sqls.get(0);
    }

    @Override
    public List<PreparedSql> getSqls() {
        return this.sqls;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return null;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return false;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }

    public String toString() {
        return this.sqls != null ? this.sqls.toString() : null;
    }
}

