/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.util.ListIterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.BatchDeleteQuery;
import org.seasar.doma.jdbc.query.SqlFileBatchModifyQuery;

public class SqlFileBatchDeleteQuery<ELEMENT>
extends SqlFileBatchModifyQuery<ELEMENT>
implements BatchDeleteQuery {
    protected EntityHandler entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileBatchDeleteQuery(Class<ELEMENT> elementClass) {
        super(elementClass, SqlKind.BATCH_DELETE);
    }

    @Override
    public void prepare() {
        super.prepare();
        int size = this.elements.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.sqlExecutionSkipCause = null;
        this.currentEntity = this.elements.get(0);
        this.preDelete();
        this.prepareSqlFile();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        this.elements.set(0, this.currentEntity);
        ListIterator<Object> it = this.elements.listIterator(1);
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preDelete();
            this.prepareSql();
            it.set(this.currentEntity);
        }
        AssertionUtil.assertEquals(size, this.sqls.size());
    }

    protected void preDelete() {
        if (this.entityHandler != null) {
            this.entityHandler.preDelete();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            ListIterator<Object> it = this.elements.listIterator();
            while (it.hasNext()) {
                this.currentEntity = it.next();
                this.entityHandler.postDelete();
                it.set(this.currentEntity);
            }
        }
    }

    @Override
    public void setEntityType(EntityType<ELEMENT> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected class EntityHandler {
        protected final EntityType<ELEMENT> entityType;
        protected final VersionPropertyType<ELEMENT, ?, ?> versionPropertyType;

        protected EntityHandler(EntityType<ELEMENT> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preDelete() {
            SqlFileBatchPreDeleteContext context = new SqlFileBatchPreDeleteContext(this.entityType, SqlFileBatchDeleteQuery.this.method, SqlFileBatchDeleteQuery.this.config);
            this.entityType.preDelete(SqlFileBatchDeleteQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchDeleteQuery.this.currentEntity = context.getNewEntity();
            }
        }

        protected void postDelete() {
            SqlFileBatchPostDeleteContext context = new SqlFileBatchPostDeleteContext(this.entityType, SqlFileBatchDeleteQuery.this.method, SqlFileBatchDeleteQuery.this.config);
            this.entityType.postDelete(SqlFileBatchDeleteQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchDeleteQuery.this.currentEntity = context.getNewEntity();
            }
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileBatchDeleteQuery.this.versionIgnored && !SqlFileBatchDeleteQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileBatchDeleteQuery.this.optimisticLockCheckRequired = true;
            }
        }
    }

    protected static class SqlFileBatchPostDeleteContext<E>
    extends AbstractPostDeleteContext<E> {
        public SqlFileBatchPostDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class SqlFileBatchPreDeleteContext<E>
    extends AbstractPreDeleteContext<E> {
        public SqlFileBatchPreDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }
}

