/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.SqlContext;
import org.seasar.doma.internal.jdbc.sql.node.ExpandNode;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.BatchModifyQuery;

public abstract class SqlFileBatchModifyQuery<ELEMENT>
extends AbstractQuery
implements BatchModifyQuery {
    protected static final String[] EMPTY_STRINGS = new String[0];
    protected final Class<ELEMENT> elementClass;
    protected final SqlKind kind;
    protected String sqlFilePath;
    protected String parameterName;
    protected SqlFile sqlFile;
    protected boolean optimisticLockCheckRequired;
    protected boolean executable;
    protected SqlExecutionSkipCause sqlExecutionSkipCause = SqlExecutionSkipCause.BATCH_TARGET_NONEXISTENT;
    protected int batchSize;
    protected SqlLogType sqlLogType;
    protected String[] includedPropertyNames = EMPTY_STRINGS;
    protected String[] excludedPropertyNames = EMPTY_STRINGS;
    protected List<ELEMENT> elements;
    protected ELEMENT currentEntity;
    protected List<PreparedSql> sqls;

    protected SqlFileBatchModifyQuery(Class<ELEMENT> elementClass, SqlKind kind) {
        AssertionUtil.assertNotNull(elementClass, (Object)kind);
        this.elementClass = elementClass;
        this.kind = kind;
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.sqlFilePath, (Object)this.parameterName, this.elements, this.sqls);
    }

    protected void prepareSqlFile() {
        this.sqlFile = this.config.getSqlFileRepository().getSqlFile(this.method, this.sqlFilePath, this.config.getDialect());
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
        if (this.batchSize <= 0) {
            this.batchSize = this.config.getBatchSize();
        }
    }

    protected void prepareSql() {
        Value value = new Value(this.elementClass, this.currentEntity);
        ExpressionEvaluator evaluator = new ExpressionEvaluator(Collections.singletonMap(this.parameterName, value), this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, this.kind, this.sqlFile.getPath(), evaluator, this.sqlLogType, this::expandColumns, this::populateValues);
        PreparedSql sql = sqlBuilder.build(this.sqlFile.getSqlNode(), this::comment);
        this.sqls.add(sql);
    }

    protected List<String> expandColumns(ExpandNode node) {
        throw new UnsupportedOperationException();
    }

    protected void populateValues(PopulateNode node, SqlContext context) {
        throw new UnsupportedOperationException();
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setElements(Iterable<ELEMENT> elements) {
        AssertionUtil.assertNotNull(elements);
        if (elements instanceof Collection) {
            this.elements = new ArrayList<ELEMENT>((Collection)elements);
        } else {
            this.elements = new ArrayList<ELEMENT>();
            for (ELEMENT element : elements) {
                this.elements.add(element);
            }
        }
        this.sqls = new ArrayList<PreparedSql>(this.elements.size());
    }

    public List<ELEMENT> getEntities() {
        return this.elements;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    public void setIncludedPropertyNames(String ... includedPropertyNames) {
        this.includedPropertyNames = includedPropertyNames;
    }

    public void setExcludedPropertyNames(String ... excludedPropertyNames) {
        this.excludedPropertyNames = excludedPropertyNames;
    }

    public abstract void setEntityType(EntityType<ELEMENT> var1);

    @Override
    public PreparedSql getSql() {
        return this.sqls.get(0);
    }

    @Override
    public List<PreparedSql> getSqls() {
        return this.sqls;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return false;
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return this.sqlExecutionSkipCause;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }

    public String toString() {
        return this.sqls.toString();
    }
}

