/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SelectOptionsAccessor;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.query.AbstractSelectQuery;

public class SqlFileSelectQuery
extends AbstractSelectQuery {
    protected String sqlFilePath;
    protected SqlFile sqlFile;

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull(this.sqlFilePath);
    }

    @Override
    protected void prepareSql() {
        this.sqlFile = this.config.getSqlFileRepository().getSqlFile(this.method, this.sqlFilePath, this.config.getDialect());
        SqlNode transformedSqlNode = this.config.getDialect().transformSelectSqlNode(this.sqlFile.getSqlNode(), this.options);
        ExpressionEvaluator evaluator = this.createExpressionEvaluator();
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, SqlKind.SELECT, this.sqlFilePath, evaluator, this.sqlLogType, this::expandColumns, this::populateValues, this::expandAggregateColumns);
        this.sql = sqlBuilder.build(transformedSqlNode, this::comment);
    }

    @Override
    public void complete() {
        if (SelectOptionsAccessor.isCount(this.options)) {
            this.executeCount(this.sqlFile.getSqlNode());
        }
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }
}

