/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.InsertRow;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class UpsertAssemblerContext {
    public final PreparedSqlBuilder buf;
    public final EntityType<?> entityType;
    public final DuplicateKeyType duplicateKeyType;
    public final Naming naming;
    public final Dialect dialect;
    public final boolean isKeysSpecified;
    public final List<? extends EntityPropertyType<?, ?>> keys;
    public final List<? extends EntityPropertyType<?, ?>> insertPropertyTypes;
    public final List<InsertRow> insertRows;
    public final List<QueryOperandPair> setValues;
    public final ReturningProperties returning;

    UpsertAssemblerContext(PreparedSqlBuilder buf, EntityType<?> entityType, DuplicateKeyType duplicateKeyType, Naming naming, Dialect dialect, boolean isKeysSpecified, List<? extends EntityPropertyType<?, ?>> keys, List<? extends EntityPropertyType<?, ?>> insertPropertyTypes, List<InsertRow> insertRows, List<QueryOperandPair> setValues, ReturningProperties returning) {
        Objects.requireNonNull(buf);
        Objects.requireNonNull(entityType);
        Objects.requireNonNull(duplicateKeyType);
        Objects.requireNonNull(naming);
        Objects.requireNonNull(dialect);
        Objects.requireNonNull(keys);
        Objects.requireNonNull(insertPropertyTypes);
        Objects.requireNonNull(insertRows);
        Objects.requireNonNull(setValues);
        Objects.requireNonNull(returning);
        if (duplicateKeyType == DuplicateKeyType.EXCEPTION) {
            throw new DomaIllegalArgumentException("duplicateKeyType", "The duplicateKeyType must not be set to EXCEPTION when performing an upsert.");
        }
        if (keys.isEmpty()) {
            throw new DomaIllegalArgumentException("keys", "The keys must not be empty when performing an upsert. At least one key must be specified.");
        }
        if (insertPropertyTypes.isEmpty()) {
            throw new DomaIllegalArgumentException("insertPropertyTypes", "The insertPropertyTypes must not be empty when performing an upsert. At least one property must be specified.");
        }
        if (insertRows.isEmpty() || insertRows.stream().anyMatch(row -> !row.iterator().hasNext())) {
            throw new DomaIllegalArgumentException("insertRows", "The insertRows must not be empty when performing an upsert. At least one insert value must be specified.");
        }
        if (duplicateKeyType == DuplicateKeyType.UPDATE && setValues.isEmpty()) {
            throw new DomaIllegalArgumentException("setValues", "The setValues must not be empty when performing an upsert with the UPDATE duplicateKeyType. At least one set value must be specified.");
        }
        this.buf = buf;
        this.entityType = entityType;
        this.duplicateKeyType = duplicateKeyType;
        this.naming = naming;
        this.dialect = dialect;
        this.isKeysSpecified = isKeysSpecified;
        this.keys = keys;
        this.insertPropertyTypes = insertPropertyTypes;
        this.insertRows = insertRows;
        this.setValues = setValues;
        this.returning = returning;
    }
}

