/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.InsertRow;
import org.seasar.doma.jdbc.query.QueryOperand;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;

public class UpsertAssemblerContextBuilder {
    public static UpsertAssemblerContext build(PreparedSqlBuilder buf, EntityType<?> entityType, DuplicateKeyType duplicateKeyType, Naming naming, Dialect dialect, List<EntityPropertyType<?, ?>> keys, List<QueryOperandPair> insertValues, List<QueryOperandPair> setValues) {
        return UpsertAssemblerContextBuilder.build(buf, entityType, duplicateKeyType, naming, dialect, keys, insertValues, setValues, ReturningProperties.NONE);
    }

    public static UpsertAssemblerContext build(PreparedSqlBuilder buf, EntityType<?> entityType, DuplicateKeyType duplicateKeyType, Naming naming, Dialect dialect, List<EntityPropertyType<?, ?>> keys, List<QueryOperandPair> insertValues, List<QueryOperandPair> setValues, ReturningProperties returning) {
        List<? extends EntityPropertyType<?, ?>> resolvedKeys = UpsertAssemblerContextBuilder.resolveKeys(entityType, keys);
        List insertPropertyTypes = insertValues.stream().map(pair -> pair.getLeft().getEntityPropertyType()).collect(Collectors.toList());
        List<QueryOperand> values = insertValues.stream().map(QueryOperandPair::getRight).collect(Collectors.toList());
        List<InsertRow> rows = Collections.singletonList(new InsertRow(values));
        return UpsertAssemblerContextBuilder.buildInternal(buf, entityType, duplicateKeyType, naming, dialect, !keys.isEmpty(), resolvedKeys, insertPropertyTypes, rows, setValues, returning);
    }

    public static <ENTITY> UpsertAssemblerContext buildFromEntity(PreparedSqlBuilder buf, EntityType<ENTITY> entityType, DuplicateKeyType duplicateKeyType, List<EntityPropertyType<ENTITY, ?>> duplicateKeys, Naming naming, Dialect dialect, List<EntityPropertyType<ENTITY, ?>> idPropertyTypes, List<EntityPropertyType<ENTITY, ?>> insertPropertyTypes, ENTITY entity) {
        return UpsertAssemblerContextBuilder.buildFromEntity(buf, entityType, duplicateKeyType, duplicateKeys, naming, dialect, idPropertyTypes, insertPropertyTypes, entity, ReturningProperties.NONE);
    }

    public static <ENTITY> UpsertAssemblerContext buildFromEntity(PreparedSqlBuilder buf, EntityType<ENTITY> entityType, DuplicateKeyType duplicateKeyType, List<EntityPropertyType<ENTITY, ?>> duplicateKeys, Naming naming, Dialect dialect, List<EntityPropertyType<ENTITY, ?>> idPropertyTypes, List<EntityPropertyType<ENTITY, ?>> insertPropertyTypes, ENTITY entity, ReturningProperties returning) {
        return UpsertAssemblerContextBuilder.buildFromEntityList(buf, entityType, duplicateKeyType, duplicateKeys, naming, dialect, idPropertyTypes, insertPropertyTypes, Collections.singletonList(entity), returning);
    }

    public static <ENTITY> UpsertAssemblerContext buildFromEntityList(PreparedSqlBuilder buf, EntityType<ENTITY> entityType, DuplicateKeyType duplicateKeyType, List<EntityPropertyType<ENTITY, ?>> duplicateKeys, Naming naming, Dialect dialect, List<EntityPropertyType<ENTITY, ?>> idPropertyTypes, List<EntityPropertyType<ENTITY, ?>> insertPropertyTypes, List<ENTITY> entities) {
        return UpsertAssemblerContextBuilder.buildFromEntityList(buf, entityType, duplicateKeyType, duplicateKeys, naming, dialect, idPropertyTypes, insertPropertyTypes, entities, ReturningProperties.NONE);
    }

    public static <ENTITY> UpsertAssemblerContext buildFromEntityList(PreparedSqlBuilder buf, EntityType<ENTITY> entityType, DuplicateKeyType duplicateKeyType, List<EntityPropertyType<ENTITY, ?>> duplicateKeys, Naming naming, Dialect dialect, List<EntityPropertyType<ENTITY, ?>> idPropertyTypes, List<EntityPropertyType<ENTITY, ?>> insertPropertyTypes, List<ENTITY> entities, ReturningProperties returning) {
        List<InsertRow> rows = entities.stream().map(entity -> insertPropertyTypes.stream().map(p -> {
            Property property = p.createProperty();
            property.load(entity);
            return new QueryOperand.Param((EntityPropertyType<?, ?>)p, property.asInParameter());
        }).collect(Collectors.toList())).map(InsertRow::new).collect(Collectors.toList());
        return UpsertAssemblerContextBuilder.buildInternal(buf, entityType, duplicateKeyType, naming, dialect, !duplicateKeys.isEmpty(), !duplicateKeys.isEmpty() ? duplicateKeys : idPropertyTypes, insertPropertyTypes, rows, Collections.emptyList(), returning);
    }

    private static UpsertAssemblerContext buildInternal(PreparedSqlBuilder buf, EntityType<?> entityType, DuplicateKeyType duplicateKeyType, Naming naming, Dialect dialect, boolean isKeysSpecified, List<? extends EntityPropertyType<?, ?>> keys, List<? extends EntityPropertyType<?, ?>> insertPropertyTypes, List<InsertRow> insertRows, List<QueryOperandPair> setValues, ReturningProperties returning) {
        List<QueryOperandPair> resolvedSetValues = UpsertAssemblerContextBuilder.resolveSetValues(keys, insertPropertyTypes, setValues);
        return new UpsertAssemblerContext(buf, entityType, duplicateKeyType, naming, dialect, isKeysSpecified, keys, insertPropertyTypes, insertRows, resolvedSetValues, returning);
    }

    private static List<? extends EntityPropertyType<?, ?>> resolveKeys(EntityType<?> entityType, List<? extends EntityPropertyType<?, ?>> keys) {
        if (!keys.isEmpty()) {
            return keys;
        }
        return entityType.getIdPropertyTypes();
    }

    private static List<QueryOperandPair> resolveSetValues(List<? extends EntityPropertyType<?, ?>> keys, List<? extends EntityPropertyType<?, ?>> insertPropertyTypes, List<QueryOperandPair> setValues) {
        if (!setValues.isEmpty()) {
            return setValues;
        }
        return insertPropertyTypes.stream().filter(p -> !keys.contains(p)).filter(p -> p.isUpdatable() && !p.isId() && !p.isTenantId()).map(p -> {
            QueryOperand.Prop operand = new QueryOperand.Prop((EntityPropertyType<?, ?>)p);
            return new QueryOperandPair(operand, operand);
        }).collect(Collectors.toList());
    }
}

