/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.statistic;

import java.util.Objects;

public record Statistic(String sql, long execCount, long execMaxTime, long execMinTime, long execTotalTime, double execAvgTime) {
    public Statistic {
        Objects.requireNonNull(sql);
    }

    public Statistic calculate(long execTimeMillis) {
        long count = this.execCount + 1L;
        long maxTime = Math.max(this.execMaxTime, execTimeMillis);
        long minTime = Math.min(this.execMinTime, execTimeMillis);
        long totalTime = this.execTotalTime + execTimeMillis;
        double avgTime = (double)totalTime / (double)count;
        return new Statistic(this.sql, count, maxTime, minTime, totalTime, avgTime);
    }

    public static Statistic of(String sql, long execTimeMillis) {
        return new Statistic(sql, 1L, execTimeMillis, execTimeMillis, execTimeMillis, execTimeMillis);
    }
}

