/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.statistic;

import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.statistic.Statistic;
import org.seasar.doma.util.ThrowingSupplier;

public interface StatisticManager {
    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public Iterable<Statistic> getStatistics();

    public void recordSqlExecution(Sql<?> var1, long var2, long var4);

    default public <RESULT, EXCEPTION extends Exception> RESULT executeSql(Sql<?> sql, ThrowingSupplier<RESULT, EXCEPTION> supplier) throws EXCEPTION {
        RESULT result;
        if (this.isEnabled()) {
            long startTimeNanos = System.nanoTime();
            result = supplier.get();
            long endTimeNanos = System.nanoTime();
            this.recordSqlExecution(sql, startTimeNanos, endTimeNanos);
        } else {
            result = supplier.get();
        }
        return result;
    }

    public void clear();
}

