/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.tx.LocalTransactionConnection;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.SavepointAlreadyExistsException;
import org.seasar.doma.jdbc.tx.SavepointNotFoundException;
import org.seasar.doma.jdbc.tx.TransactionAlreadyBegunException;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;
import org.seasar.doma.jdbc.tx.TransactionNotYetBegunException;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class LocalTransaction {
    protected final DataSource dataSource;
    protected final ThreadLocal<LocalTransactionContext> localTxContextHolder;
    protected final JdbcLogger jdbcLogger;
    protected final TransactionIsolationLevel defaultTransactionIsolationLevel;
    protected final String className;

    protected LocalTransaction(DataSource dataSource, ThreadLocal<LocalTransactionContext> localTxContextHolder, JdbcLogger jdbcLogger) {
        this(dataSource, localTxContextHolder, jdbcLogger, null);
    }

    protected LocalTransaction(DataSource dataSource, ThreadLocal<LocalTransactionContext> localTxContextHolder, JdbcLogger jdbcLogger, TransactionIsolationLevel defaultTransactionIsolationLevel) {
        AssertionUtil.assertNotNull((Object)dataSource, localTxContextHolder, (Object)jdbcLogger);
        this.dataSource = dataSource;
        this.localTxContextHolder = localTxContextHolder;
        this.jdbcLogger = jdbcLogger;
        this.defaultTransactionIsolationLevel = defaultTransactionIsolationLevel;
        this.className = this.getClass().getName();
    }

    public void begin() {
        this.beginInternal(this.defaultTransactionIsolationLevel, "begin");
    }

    public void begin(TransactionIsolationLevel transactionIsolationLevel) {
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        this.beginInternal(transactionIsolationLevel, "begin");
    }

    protected void beginInternal(TransactionIsolationLevel transactionIsolationLevel, String callerMethodName) {
        AssertionUtil.assertNotNull(callerMethodName);
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (this.isActiveInternal(context)) {
            String id = context.getId();
            this.rollbackInternal(callerMethodName);
            throw new TransactionAlreadyBegunException(id);
        }
        context = this.getLocalTransactionContext();
        context.begin(() -> {
            boolean isAutoCommit;
            Connection connection = JdbcUtil.getConnection(this.dataSource);
            Integer preservedTransactionIsolation = null;
            if (transactionIsolationLevel != null && transactionIsolationLevel != TransactionIsolationLevel.DEFAULT) {
                int currentTransactionIsolation;
                try {
                    currentTransactionIsolation = connection.getTransactionIsolation();
                }
                catch (SQLException e) {
                    this.closeConnection(connection);
                    throw new JdbcException((MessageResource)Message.DOMA2056, (Throwable)e, e);
                }
                int level = transactionIsolationLevel.getLevel();
                if (currentTransactionIsolation != level) {
                    try {
                        connection.setTransactionIsolation(level);
                        preservedTransactionIsolation = currentTransactionIsolation;
                    }
                    catch (SQLException e) {
                        this.closeConnection(connection);
                        throw new JdbcException((MessageResource)Message.DOMA2055, (Throwable)e, transactionIsolationLevel.name(), e);
                    }
                }
            }
            try {
                isAutoCommit = connection.getAutoCommit();
            }
            catch (SQLException e) {
                this.closeConnection(connection);
                throw new JdbcException((MessageResource)Message.DOMA2084, (Throwable)e, e);
            }
            if (isAutoCommit) {
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    this.closeConnection(connection);
                    throw new JdbcException((MessageResource)Message.DOMA2041, (Throwable)e, e);
                }
            }
            return new LocalTransactionConnection(connection, preservedTransactionIsolation, isAutoCommit);
        });
        this.jdbcLogger.logTransactionBegun(this.className, callerMethodName, context.getId());
    }

    protected LocalTransactionContext getLocalTransactionContext() {
        LocalTransactionContext context = new LocalTransactionContext();
        this.localTxContextHolder.set(context);
        return context;
    }

    public void commit() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new TransactionNotYetBegunException(Message.DOMA2046, new Object[0]);
        }
        if (context.hasConnection()) {
            LocalTransactionConnection connection = context.getConnection();
            try {
                connection.commit();
                this.jdbcLogger.logTransactionCommitted(this.className, "commit", context.getId());
            }
            catch (SQLException e) {
                this.rollbackInternal("commit");
                throw new JdbcException((MessageResource)Message.DOMA2043, (Throwable)e, e);
            }
            finally {
                this.end("commit");
            }
        } else {
            this.end("commit");
        }
    }

    public LocalTransactionContext suspend() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new TransactionNotYetBegunException(Message.DOMA2046, new Object[0]);
        }
        this.localTxContextHolder.remove();
        return context;
    }

    public void resume(LocalTransactionContext context) {
        LocalTransactionContext currentContext = this.localTxContextHolder.get();
        if (this.isActiveInternal(currentContext)) {
            this.rollbackInternal("resume");
        }
        this.localTxContextHolder.set(context);
    }

    public void rollback() {
        this.rollbackInternal("rollback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackInternal(String callerMethodName) {
        AssertionUtil.assertNotNull(callerMethodName);
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            return;
        }
        if (context.hasConnection()) {
            LocalTransactionConnection connection = context.getConnection();
            String id = context.getId();
            try {
                connection.rollback();
                this.jdbcLogger.logTransactionRolledback(this.className, callerMethodName, id);
            }
            catch (SQLException e) {
                this.jdbcLogger.logTransactionRollbackFailure(this.className, callerMethodName, id, e);
            }
            finally {
                this.end(callerMethodName);
            }
        } else {
            this.end(callerMethodName);
        }
    }

    public void setSavepoint(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("setSavepoint");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new TransactionNotYetBegunException(Message.DOMA2053, savepointName);
        }
        String id = context.getId();
        Savepoint savepoint = context.getSavepoint(savepointName);
        if (savepoint != null) {
            this.rollbackInternal("setSavepoint");
            throw new SavepointAlreadyExistsException(savepointName);
        }
        LocalTransactionConnection connection = context.getConnection();
        try {
            savepoint = connection.setSavepoint(savepointName);
        }
        catch (SQLException e) {
            this.rollbackInternal("setSavepoint");
            throw new JdbcException((MessageResource)Message.DOMA2051, (Throwable)e, savepointName, e);
        }
        context.addSavepoint(savepointName, savepoint);
        this.jdbcLogger.logTransactionSavepointCreated(this.className, "setSavepoint", id, savepointName);
    }

    public boolean hasSavepoint(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("hasSavepoint");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new TransactionNotYetBegunException(Message.DOMA2057, savepointName);
        }
        return context.getSavepoint(savepointName) != null;
    }

    public void releaseSavepoint(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("releaseSavepoint");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new TransactionNotYetBegunException(Message.DOMA2061, savepointName);
        }
        String id = context.getId();
        Savepoint savepoint = context.releaseAndGetSavepoint(savepointName);
        if (savepoint == null) {
            this.rollbackInternal("releaseSavepoint");
            throw new SavepointNotFoundException(savepointName);
        }
        LocalTransactionConnection connection = context.getConnection();
        try {
            connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.rollbackInternal("releaseSavepoint");
            throw new JdbcException((MessageResource)Message.DOMA2060, (Throwable)e, savepointName, e);
        }
        this.jdbcLogger.logTransactionSavepointReleased(this.className, "releaseSavepoint", id, savepointName);
    }

    public void rollback(String savepointName) {
        if (savepointName == null) {
            this.rollbackInternal("rollback");
            throw new DomaNullPointerException("savepointName");
        }
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            throw new TransactionNotYetBegunException(Message.DOMA2062, savepointName);
        }
        String id = context.getId();
        Savepoint savepoint = context.getSavepoint(savepointName);
        if (savepoint == null) {
            this.rollbackInternal("rollback");
            throw new SavepointNotFoundException(savepointName);
        }
        LocalTransactionConnection connection = context.getConnection();
        try {
            connection.rollback(savepoint);
        }
        catch (SQLException e) {
            this.rollbackInternal("rollback");
            throw new JdbcException((MessageResource)Message.DOMA2052, (Throwable)e, savepointName, e);
        }
        this.jdbcLogger.logTransactionSavepointRolledback(this.className, "rollback", id, savepointName);
    }

    protected void end(String callerMethodName) {
        AssertionUtil.assertNotNull(callerMethodName);
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (!this.isActiveInternal(context)) {
            return;
        }
        this.endInternal(context, callerMethodName);
        context.end();
    }

    protected void endInternal(LocalTransactionContext context, String callerMethodName) {
        this.release(context, callerMethodName);
        this.jdbcLogger.logTransactionEnded(this.className, callerMethodName, context.getId());
    }

    protected void release(LocalTransactionContext context, String callerMethodName) {
        boolean isAutoCommit;
        AssertionUtil.assertNotNull((Object)context, (Object)callerMethodName);
        this.localTxContextHolder.remove();
        if (!context.hasConnection()) {
            return;
        }
        LocalTransactionConnection localTransactionConnection = context.getConnection();
        Connection connection = localTransactionConnection.getWrappedConnection();
        Integer isolationLevel = localTransactionConnection.getPreservedTransactionIsolation();
        if (isolationLevel != null && isolationLevel != 0) {
            try {
                connection.setTransactionIsolation(isolationLevel);
            }
            catch (SQLException e) {
                this.jdbcLogger.logTransactionIsolationSettingFailure(this.className, callerMethodName, isolationLevel, e);
            }
        }
        if (isAutoCommit = localTransactionConnection.getPreservedAutoCommitState()) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.jdbcLogger.logAutoCommitEnablingFailure(this.className, callerMethodName, e);
            }
        }
        this.closeConnection(connection);
    }

    protected void closeConnection(Connection connection) {
        JdbcUtil.close(connection, this.jdbcLogger);
    }

    public String toString() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        String transactionId = context != null ? context.getId() : "null";
        return "{LocalTransaction transactionId=" + transactionId + "}";
    }

    public boolean isActive() {
        return this.isActiveInternal(this.localTxContextHolder.get());
    }

    protected boolean isActiveInternal(LocalTransactionContext context) {
        return context != null;
    }

    public void setRollbackOnly() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (this.isActiveInternal(context)) {
            context.setRollbackOnly();
        }
    }

    public boolean isRollbackOnly() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (this.isActiveInternal(context)) {
            return context.isRollbackOnly();
        }
        return false;
    }
}

