/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.SimpleDataSource;
import org.seasar.doma.jdbc.tx.KeepAliveLocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;

public final class LocalTransactionDataSource
implements DataSource {
    private final ThreadLocal<LocalTransactionContext> localTxContextHolder = new ThreadLocal();
    private final DataSource dataSource;

    public LocalTransactionDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new DomaNullPointerException("dataSource");
        }
        this.dataSource = dataSource;
    }

    public LocalTransactionDataSource(String url, String user, String password) {
        if (url == null) {
            throw new DomaNullPointerException("url");
        }
        SimpleDataSource simpleDataSource = new SimpleDataSource();
        simpleDataSource.setUrl(url);
        if (user != null) {
            simpleDataSource.setUser(user);
        }
        if (password != null) {
            simpleDataSource.setPassword(password);
        }
        this.dataSource = simpleDataSource;
    }

    @Override
    public Connection getConnection() {
        return this.getConnectionInternal();
    }

    @Override
    public Connection getConnection(String username, String password) {
        return this.getConnectionInternal();
    }

    private Connection getConnectionInternal() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (context == null) {
            return JdbcUtil.getConnection(this.dataSource);
        }
        return context.getConnection();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == null) {
            return false;
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException("iface must not be null");
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.dataSource.unwrap(iface);
    }

    public LocalTransaction getLocalTransaction(JdbcLogger jdbcLogger) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        return new LocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger);
    }

    public LocalTransaction getLocalTransaction(JdbcLogger jdbcLogger, TransactionIsolationLevel transactionIsolationLevel) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        return new LocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger, transactionIsolationLevel);
    }

    public KeepAliveLocalTransaction getKeepAliveLocalTransaction(JdbcLogger jdbcLogger) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        return new KeepAliveLocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger);
    }

    public KeepAliveLocalTransaction getKeepAliveLocalTransaction(JdbcLogger jdbcLogger, TransactionIsolationLevel transactionIsolationLevel) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        return new KeepAliveLocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger, transactionIsolationLevel);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }
}

