/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class ByteWrapper
extends AbstractWrapper<Byte>
implements NumberWrapper<Byte> {
    public ByteWrapper() {
        super(Byte.class);
    }

    public ByteWrapper(Byte value) {
        super(Byte.class, value);
    }

    @Override
    public void set(Number v) {
        if (v == null) {
            super.set(null);
        } else {
            super.set(v.byteValue());
        }
    }

    @Override
    public void increment() {
        Byte value = (Byte)this.doGet();
        if (value != null) {
            this.doSet((byte)(value + 1));
        }
    }

    @Override
    public void decrement() {
        Byte value = (Byte)this.doGet();
        if (value != null) {
            this.doSet((byte)(value - 1));
        }
    }

    @Override
    public <R, P, Q, TH extends Throwable> R accept(WrapperVisitor<R, P, Q, TH> visitor, P p, Q q) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitByteWrapper(this, p, q);
    }
}

