/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class DoubleWrapper
extends AbstractWrapper<Double>
implements NumberWrapper<Double> {
    public DoubleWrapper() {
        super(Double.class);
    }

    public DoubleWrapper(Double value) {
        super(Double.class, value);
    }

    @Override
    public void set(Number v) {
        if (v == null) {
            super.set(null);
        } else {
            super.set(v.doubleValue());
        }
    }

    @Override
    public void increment() {
        Double value = (Double)this.doGet();
        if (value != null) {
            this.doSet(value + 1.0);
        }
    }

    @Override
    public void decrement() {
        Double value = (Double)this.doGet();
        if (value != null) {
            this.doSet(value - 1.0);
        }
    }

    @Override
    public <R, P, Q, TH extends Throwable> R accept(WrapperVisitor<R, P, Q, TH> visitor, P p, Q q) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitDoubleWrapper(this, p, q);
    }
}

