/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class IntegerWrapper
extends AbstractWrapper<Integer>
implements NumberWrapper<Integer> {
    public IntegerWrapper() {
        super(Integer.class);
    }

    public IntegerWrapper(Integer value) {
        super(Integer.class, value);
    }

    @Override
    public void set(Number v) {
        if (v == null) {
            super.set(null);
        } else {
            super.set(v.intValue());
        }
    }

    @Override
    public void increment() {
        Integer value = (Integer)this.doGet();
        if (value != null) {
            this.doSet(value + 1);
        }
    }

    @Override
    public void decrement() {
        Integer value = (Integer)this.doGet();
        if (value != null) {
            this.doSet(value - 1);
        }
    }

    @Override
    public <R, P, Q, TH extends Throwable> R accept(WrapperVisitor<R, P, Q, TH> visitor, P p, Q q) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitIntegerWrapper(this, p, q);
    }
}

