/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class ShortWrapper
extends AbstractWrapper<Short>
implements NumberWrapper<Short> {
    public ShortWrapper() {
        super(Short.class);
    }

    public ShortWrapper(Short value) {
        super(Short.class, value);
    }

    @Override
    public void set(Number v) {
        if (v == null) {
            super.set(null);
        } else {
            super.set(v.shortValue());
        }
    }

    @Override
    public void increment() {
        Short value = (Short)this.doGet();
        if (value != null) {
            this.doSet((short)(value + 1));
        }
    }

    @Override
    public void decrement() {
        Short value = (Short)this.doGet();
        if (value != null) {
            this.doSet((short)(value - 1));
        }
    }

    @Override
    public <R, P, Q, TH extends Throwable> R accept(WrapperVisitor<R, P, Q, TH> visitor, P p, Q q) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitShortWrapper(this, p, q);
    }
}

