/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.StandardDialect;
import org.seasar.doma.template.SqlArgument;
import org.seasar.doma.template.SqlStatement;
import org.seasar.doma.wrapper.Wrapper;

public class SqlTemplate {
    private final String sql;
    private final Config config;
    private final Map<String, Value> values = new HashMap<String, Value>();

    public SqlTemplate(String sql) {
        this(sql, (Dialect)new StandardDialect());
    }

    public SqlTemplate(String sql, final Dialect dialect) {
        this(sql, new Config(){

            public DataSource getDataSource() {
                throw new UnsupportedOperationException();
            }

            public Dialect getDialect() {
                return dialect;
            }
        });
        Objects.requireNonNull(dialect);
    }

    public SqlTemplate(String sql, Config config) {
        this.sql = Objects.requireNonNull(sql);
        this.config = Objects.requireNonNull(config);
    }

    public <T> SqlTemplate add(String name, Class<T> type, T value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        this.values.put(name, new Value(type, value));
        return this;
    }

    public SqlStatement execute() {
        SqlParser parser = new SqlParser(this.sql);
        SqlNode node = parser.parse();
        NodePreparedSqlBuilder builder = this.createNodePreparedSqlBuilder();
        PreparedSql preparedSql = builder.build(node, Function.identity());
        return this.toSqlStatement(preparedSql);
    }

    private NodePreparedSqlBuilder createNodePreparedSqlBuilder() {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.values, this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
        return new NodePreparedSqlBuilder(this.config, SqlKind.SCRIPT, null, evaluator, SqlLogType.FORMATTED);
    }

    private SqlStatement toSqlStatement(PreparedSql preparedSql) {
        List<SqlArgument> arguments = preparedSql.getParameters().stream().map(it -> {
            Wrapper w = it.getWrapper();
            return new SqlArgument(w.getBasicClass(), w.get());
        }).collect(Collectors.toList());
        return new SqlStatement(preparedSql.getRawSql(), preparedSql.getFormattedSql(), arguments);
    }
}

