/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.util.thread.strategy;

import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.LongAdder;
import org.seleniumhq.jetty9.util.annotation.ManagedAttribute;
import org.seleniumhq.jetty9.util.annotation.ManagedObject;
import org.seleniumhq.jetty9.util.annotation.ManagedOperation;
import org.seleniumhq.jetty9.util.component.ContainerLifeCycle;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;
import org.seleniumhq.jetty9.util.thread.ExecutionStrategy;
import org.seleniumhq.jetty9.util.thread.Invocable;
import org.seleniumhq.jetty9.util.thread.Locker;
import org.seleniumhq.jetty9.util.thread.ReservedThreadExecutor;

@ManagedObject(value="eat what you kill execution strategy")
public class EatWhatYouKill
extends ContainerLifeCycle
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = Log.getLogger(EatWhatYouKill.class);
    private final Locker _locker = new Locker();
    private final LongAdder _nonBlocking = new LongAdder();
    private final LongAdder _blocking = new LongAdder();
    private final LongAdder _executed = new LongAdder();
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private final ReservedThreadExecutor _producers;
    private State _state = State.IDLE;

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor) {
        this(producer, executor, new ReservedThreadExecutor(executor, 1));
    }

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor, int maxReserved) {
        this(producer, executor, new ReservedThreadExecutor(executor, maxReserved));
    }

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor, ReservedThreadExecutor producers) {
        this._producer = producer;
        this._executor = executor;
        this._producers = producers;
        this.addBean(this._producer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} created", this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void dispatch() {
        execute = false;
        locked = this._locker.lock();
        var3_3 = null;
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$thread$strategy$EatWhatYouKill$State[this._state.ordinal()]) {
                case 1: {
                    execute = true;
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 2: {
                    this._state = State.REPRODUCING;
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                ** default:
lbl15:
                // 1 sources

                break;
            }
        }
        catch (Throwable var4_4) {
            var3_3 = var4_4;
            throw var4_4;
        }
        finally {
            if (locked != null) {
                EatWhatYouKill.$closeResource(var3_3, locked);
            }
        }
        if (EatWhatYouKill.LOG.isDebugEnabled()) {
            EatWhatYouKill.LOG.debug("{} dispatch {}", new Object[]{this, execute});
        }
        if (execute) {
            this._executor.execute(this);
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} run", this);
        }
        this.produce();
    }

    @Override
    public void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce", this);
        }
        boolean reproduce = true;
        while (this.isRunning() && this.tryProduce(reproduce) && this.doProduce()) {
            reproduce = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryProduce(boolean reproduce) {
        boolean producing = false;
        try (Locker.Lock locked = this._locker.lock();){
            switch (this._state) {
                case IDLE: {
                    this._state = State.PRODUCING;
                    producing = true;
                    return producing;
                }
                case PRODUCING: {
                    if (!reproduce) return producing;
                    this._state = State.REPRODUCING;
                    return producing;
                }
            }
            return producing;
        }
    }

    public boolean doProduce() {
        boolean producing = true;
        while (this.isRunning() && producing) {
            boolean consume;
            Runnable task = null;
            try {
                task = this._producer.produce();
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} t={}/{}", new Object[]{this, task, Invocable.getInvocationType(task)});
            }
            if (task == null) {
                Locker.Lock locked = this._locker.lock();
                Throwable throwable = null;
                try {
                    if (this._state == State.REPRODUCING) {
                        this._state = State.PRODUCING;
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} IDLE", this.toStringLocked());
                    }
                    this._state = State.IDLE;
                    producing = false;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (locked != null) {
                        EatWhatYouKill.$closeResource(throwable, locked);
                    }
                    continue;
                }
            }
            if (Invocable.getInvocationType(task) == Invocable.InvocationType.NON_BLOCKING) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} PC t={}", this, task);
                }
                consume = true;
                this._nonBlocking.increment();
            } else {
                try (Locker.Lock locked = this._locker.lock();){
                    if (this._producers.tryExecute(this)) {
                        this._state = State.IDLE;
                        producing = false;
                        consume = true;
                        this._blocking.increment();
                    } else {
                        consume = false;
                        this._executed.increment();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {} t={}", this, consume ? "EPC" : "PEC", task);
                }
            }
            try {
                if (consume) {
                    task.run();
                    continue;
                }
                this._executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                LOG.warn(e);
                if (!(task instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)task)).close();
                }
                catch (Throwable e2) {
                    LOG.ignore(e2);
                }
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return producing;
    }

    @ManagedAttribute(value="number of non blocking tasks consumed", readonly=true)
    public long getNonBlockingTasksConsumed() {
        return this._nonBlocking.longValue();
    }

    @ManagedAttribute(value="number of blocking tasks consumed", readonly=true)
    public long getBlockingTasksConsumed() {
        return this._blocking.longValue();
    }

    @ManagedAttribute(value="number of blocking tasks executed", readonly=true)
    public long getBlockingTasksExecuted() {
        return this._executed.longValue();
    }

    @ManagedAttribute(value="whether this execution strategy is idle", readonly=true)
    public boolean isIdle() {
        try (Locker.Lock locked = this._locker.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    @ManagedOperation(value="resets the task counts", impact="ACTION")
    public void reset() {
        this._nonBlocking.reset();
        this._blocking.reset();
        this._executed.reset();
    }

    public String toString() {
        try (Locker.Lock locked = this._locker.lock();){
            String string = this.toStringLocked();
            return string;
        }
    }

    public String toStringLocked() {
        StringBuilder builder = new StringBuilder();
        this.getString(builder);
        this.getState(builder);
        return builder.toString();
    }

    private void getString(StringBuilder builder) {
        builder.append(this.getClass().getSimpleName());
        builder.append('@');
        builder.append(Integer.toHexString(this.hashCode()));
        builder.append('/');
        builder.append(this._producer);
        builder.append('/');
    }

    private void getState(StringBuilder builder) {
        builder.append((Object)this._state);
        builder.append('/');
        builder.append(this._producers);
    }

    private static enum State {
        IDLE,
        PRODUCING,
        REPRODUCING;

    }
}

