/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeExtension;
import org.openqa.selenium.chrome.ChromeProfile;

public class ChromeBinary {
    private static final int BACKOFF_INTERVAL = 2500;
    private static int linearBackoffCoefficient = 1;
    private final ChromeProfile profile;
    private final ChromeExtension extension;
    Process chromeProcess = null;

    public ChromeBinary(ChromeProfile profile, ChromeExtension extension) {
        this.profile = profile;
        this.extension = extension;
    }

    public void start(String serverUrl) throws IOException {
        try {
            this.chromeProcess = new ProcessBuilder(this.getChromeFile(), "--user-data-dir=" + this.profile.getDirectory().getAbsolutePath(), "--load-extension=" + this.extension.getDirectory().getAbsolutePath(), "--activate-on-launch", "--homepage=about:blank", "--no-first-run", "--disable-hang-monitor", "--disable-popup-blocking", "--disable-prompt-on-repost", "--no-default-browser-check", serverUrl).start();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        try {
            Thread.sleep(2500 * linearBackoffCoefficient);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void kill() {
        if (this.chromeProcess != null) {
            this.chromeProcess.destroy();
            this.chromeProcess = null;
        }
    }

    public void incrementBackoffBy(int diff) {
        linearBackoffCoefficient += diff;
    }

    protected String getChromeFile() throws IOException {
        File chromeFile = null;
        String chromeFileSystemProperty = System.getProperty("webdriver.chrome.bin");
        if (chromeFileSystemProperty != null) {
            chromeFile = new File(chromeFileSystemProperty);
        } else {
            StringBuilder chromeFileString = new StringBuilder();
            if (Platform.getCurrent().is(Platform.XP)) {
                chromeFileString.append(System.getProperty("user.home")).append("\\Local Settings\\Application Data\\").append("Google\\Chrome\\Application\\chrome.exe");
            } else if (Platform.getCurrent().is(Platform.VISTA)) {
                chromeFileString.append(System.getProperty("java.io.tmpdir")).append("..\\").append("Google\\Chrome\\Application\\chrome.exe");
            } else if (Platform.getCurrent().is(Platform.UNIX)) {
                chromeFileString.append("/usr/bin/google-chrome");
            } else if (Platform.getCurrent().is(Platform.MAC)) {
                String[] paths = new String[]{"/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "/Users/" + System.getProperty("user.name") + "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome"};
                boolean foundPath = false;
                for (String path : paths) {
                    File binary = new File(path);
                    if (!binary.exists()) continue;
                    chromeFileString.append(binary.getCanonicalFile());
                    foundPath = true;
                    break;
                }
                if (!foundPath) {
                    throw new WebDriverException("Couldn't locate Chrome.  Set webdriver.chrome.bin");
                }
            } else {
                throw new WebDriverException("Unsupported operating system.  Could not locate Chrome.  Set webdriver.chrome.bin");
            }
            chromeFile = new File(chromeFileString.toString());
        }
        return chromeFile.getCanonicalFile().toString();
    }
}

