package org.openqa.selenium.devtools.v111.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class WasmDisassemblyChunk {

    private final java.util.List<java.lang.String> lines;

    private final java.util.List<java.lang.Integer> bytecodeOffsets;

    public WasmDisassemblyChunk(java.util.List<java.lang.String> lines, java.util.List<java.lang.Integer> bytecodeOffsets) {
        this.lines = java.util.Objects.requireNonNull(lines, "lines is required");
        this.bytecodeOffsets = java.util.Objects.requireNonNull(bytecodeOffsets, "bytecodeOffsets is required");
    }

    /**
     * The next chunk of disassembled lines.
     */
    public java.util.List<java.lang.String> getLines() {
        return lines;
    }

    /**
     * The bytecode offsets describing the start of each line.
     */
    public java.util.List<java.lang.Integer> getBytecodeOffsets() {
        return bytecodeOffsets;
    }

    private static WasmDisassemblyChunk fromJson(JsonInput input) {
        java.util.List<java.lang.String> lines = null;
        java.util.List<java.lang.Integer> bytecodeOffsets = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "lines":
                    lines = input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {
                    }.getType());
                    break;
                case "bytecodeOffsets":
                    bytecodeOffsets = input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.Integer>>() {
                    }.getType());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WasmDisassemblyChunk(lines, bytecodeOffsets);
    }
}
