package org.openqa.selenium.devtools.v111.tracing.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class BufferUsage {

    private final java.util.Optional<java.lang.Number> percentFull;

    private final java.util.Optional<java.lang.Number> eventCount;

    private final java.util.Optional<java.lang.Number> value;

    public BufferUsage(java.util.Optional<java.lang.Number> percentFull, java.util.Optional<java.lang.Number> eventCount, java.util.Optional<java.lang.Number> value) {
        this.percentFull = percentFull;
        this.eventCount = eventCount;
        this.value = value;
    }

    /**
     * A number in range [0..1] that indicates the used size of event buffer as a fraction of its
     * total size.
     */
    public java.util.Optional<java.lang.Number> getPercentFull() {
        return percentFull;
    }

    /**
     * An approximate number of events in the trace log.
     */
    public java.util.Optional<java.lang.Number> getEventCount() {
        return eventCount;
    }

    /**
     * A number in range [0..1] that indicates the used size of event buffer as a fraction of its
     * total size.
     */
    public java.util.Optional<java.lang.Number> getValue() {
        return value;
    }

    private static BufferUsage fromJson(JsonInput input) {
        java.util.Optional<java.lang.Number> percentFull = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> eventCount = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> value = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "percentFull":
                    percentFull = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "eventCount":
                    eventCount = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BufferUsage(percentFull, eventCount, value);
    }
}
