package org.openqa.selenium.devtools.v114.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a prefetch attempt is updated.
 */
public class PrefetchStatusUpdated {

    private final org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey key;

    private final org.openqa.selenium.devtools.v114.page.model.FrameId initiatingFrameId;

    private final java.lang.String prefetchUrl;

    private final org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus status;

    public PrefetchStatusUpdated(org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey key, org.openqa.selenium.devtools.v114.page.model.FrameId initiatingFrameId, java.lang.String prefetchUrl, org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus status) {
        this.key = java.util.Objects.requireNonNull(key, "key is required");
        this.initiatingFrameId = java.util.Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prefetchUrl = java.util.Objects.requireNonNull(prefetchUrl, "prefetchUrl is required");
        this.status = java.util.Objects.requireNonNull(status, "status is required");
    }

    public org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey getKey() {
        return key;
    }

    /**
     * The frame id of the frame initiating prefetch.
     */
    public org.openqa.selenium.devtools.v114.page.model.FrameId getInitiatingFrameId() {
        return initiatingFrameId;
    }

    public java.lang.String getPrefetchUrl() {
        return prefetchUrl;
    }

    public org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus getStatus() {
        return status;
    }

    private static PrefetchStatusUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey key = null;
        org.openqa.selenium.devtools.v114.page.model.FrameId initiatingFrameId = null;
        java.lang.String prefetchUrl = null;
        org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus status = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "key":
                    key = input.read(org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey.class);
                    break;
                case "initiatingFrameId":
                    initiatingFrameId = input.read(org.openqa.selenium.devtools.v114.page.model.FrameId.class);
                    break;
                case "prefetchUrl":
                    prefetchUrl = input.nextString();
                    break;
                case "status":
                    status = input.read(org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrefetchStatusUpdated(key, initiatingFrameId, prefetchUrl, status);
    }
}
