package org.openqa.selenium.devtools.v114.target.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The entries in TargetFilter are matched sequentially against targets and
 * the first entry that matches determines if the target is included or not,
 * depending on the value of `exclude` field in the entry.
 * If filter is not specified, the one assumed is
 * [{type: "browser", exclude: true}, {type: "tab", exclude: true}, {}]
 * (i.e. include everything but `browser` and `tab`).
 */
@org.openqa.selenium.Beta()
public class TargetFilter {

    private final java.util.List<org.openqa.selenium.devtools.v114.target.model.FilterEntry> targetFilter;

    public TargetFilter(java.util.List<org.openqa.selenium.devtools.v114.target.model.FilterEntry> targetFilter) {
        this.targetFilter = java.util.Objects.requireNonNull(targetFilter, "Missing value for TargetFilter");
    }

    private static TargetFilter fromJson(JsonInput input) {
        return input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v114.target.model.FilterEntry>>() {
        }.getType());
    }

    public String toString() {
        return targetFilter.toString();
    }
}
