package org.openqa.selenium.devtools.v123.autofill.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Specified whether a filled field was done so by using the html autocomplete attribute or autofill heuristics.
 */
public enum FillingStrategy {

    AUTOCOMPLETEATTRIBUTE("autocompleteAttribute"), AUTOFILLINFERRED("autofillInferred");

    private String value;

    FillingStrategy(String value) {
        this.value = value;
    }

    public static FillingStrategy fromString(String s) {
        return java.util.Arrays.stream(FillingStrategy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within FillingStrategy "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static FillingStrategy fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
