package org.openqa.selenium.devtools.v123.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum CrossOriginEmbedderPolicyValue {

    NONE("None"), CREDENTIALLESS("Credentialless"), REQUIRECORP("RequireCorp");

    private String value;

    CrossOriginEmbedderPolicyValue(String value) {
        this.value = value;
    }

    public static CrossOriginEmbedderPolicyValue fromString(String s) {
        return java.util.Arrays.stream(CrossOriginEmbedderPolicyValue.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CrossOriginEmbedderPolicyValue "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CrossOriginEmbedderPolicyValue fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
