package org.openqa.selenium.devtools.v123.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ServiceWorkerRouterInfo {

    private final java.lang.Integer ruleIdMatched;

    private final org.openqa.selenium.devtools.v123.network.model.ServiceWorkerRouterSource matchedSourceType;

    public ServiceWorkerRouterInfo(java.lang.Integer ruleIdMatched, org.openqa.selenium.devtools.v123.network.model.ServiceWorkerRouterSource matchedSourceType) {
        this.ruleIdMatched = java.util.Objects.requireNonNull(ruleIdMatched, "ruleIdMatched is required");
        this.matchedSourceType = java.util.Objects.requireNonNull(matchedSourceType, "matchedSourceType is required");
    }

    public java.lang.Integer getRuleIdMatched() {
        return ruleIdMatched;
    }

    public org.openqa.selenium.devtools.v123.network.model.ServiceWorkerRouterSource getMatchedSourceType() {
        return matchedSourceType;
    }

    private static ServiceWorkerRouterInfo fromJson(JsonInput input) {
        java.lang.Integer ruleIdMatched = 0;
        org.openqa.selenium.devtools.v123.network.model.ServiceWorkerRouterSource matchedSourceType = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "ruleIdMatched":
                    ruleIdMatched = input.nextNumber().intValue();
                    break;
                case "matchedSourceType":
                    matchedSourceType = input.read(org.openqa.selenium.devtools.v123.network.model.ServiceWorkerRouterSource.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ServiceWorkerRouterInfo(ruleIdMatched, matchedSourceType);
    }
}
