package org.openqa.selenium.devtools.v123.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a preload enabled state is updated.
 */
public class PreloadEnabledStateUpdated {

    private final java.lang.Boolean disabledByPreference;

    private final java.lang.Boolean disabledByDataSaver;

    private final java.lang.Boolean disabledByBatterySaver;

    private final java.lang.Boolean disabledByHoldbackPrefetchSpeculationRules;

    private final java.lang.Boolean disabledByHoldbackPrerenderSpeculationRules;

    public PreloadEnabledStateUpdated(java.lang.Boolean disabledByPreference, java.lang.Boolean disabledByDataSaver, java.lang.Boolean disabledByBatterySaver, java.lang.Boolean disabledByHoldbackPrefetchSpeculationRules, java.lang.Boolean disabledByHoldbackPrerenderSpeculationRules) {
        this.disabledByPreference = java.util.Objects.requireNonNull(disabledByPreference, "disabledByPreference is required");
        this.disabledByDataSaver = java.util.Objects.requireNonNull(disabledByDataSaver, "disabledByDataSaver is required");
        this.disabledByBatterySaver = java.util.Objects.requireNonNull(disabledByBatterySaver, "disabledByBatterySaver is required");
        this.disabledByHoldbackPrefetchSpeculationRules = java.util.Objects.requireNonNull(disabledByHoldbackPrefetchSpeculationRules, "disabledByHoldbackPrefetchSpeculationRules is required");
        this.disabledByHoldbackPrerenderSpeculationRules = java.util.Objects.requireNonNull(disabledByHoldbackPrerenderSpeculationRules, "disabledByHoldbackPrerenderSpeculationRules is required");
    }

    public java.lang.Boolean getDisabledByPreference() {
        return disabledByPreference;
    }

    public java.lang.Boolean getDisabledByDataSaver() {
        return disabledByDataSaver;
    }

    public java.lang.Boolean getDisabledByBatterySaver() {
        return disabledByBatterySaver;
    }

    public java.lang.Boolean getDisabledByHoldbackPrefetchSpeculationRules() {
        return disabledByHoldbackPrefetchSpeculationRules;
    }

    public java.lang.Boolean getDisabledByHoldbackPrerenderSpeculationRules() {
        return disabledByHoldbackPrerenderSpeculationRules;
    }

    private static PreloadEnabledStateUpdated fromJson(JsonInput input) {
        java.lang.Boolean disabledByPreference = false;
        java.lang.Boolean disabledByDataSaver = false;
        java.lang.Boolean disabledByBatterySaver = false;
        java.lang.Boolean disabledByHoldbackPrefetchSpeculationRules = false;
        java.lang.Boolean disabledByHoldbackPrerenderSpeculationRules = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "disabledByPreference":
                    disabledByPreference = input.nextBoolean();
                    break;
                case "disabledByDataSaver":
                    disabledByDataSaver = input.nextBoolean();
                    break;
                case "disabledByBatterySaver":
                    disabledByBatterySaver = input.nextBoolean();
                    break;
                case "disabledByHoldbackPrefetchSpeculationRules":
                    disabledByHoldbackPrefetchSpeculationRules = input.nextBoolean();
                    break;
                case "disabledByHoldbackPrerenderSpeculationRules":
                    disabledByHoldbackPrerenderSpeculationRules = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PreloadEnabledStateUpdated(disabledByPreference, disabledByDataSaver, disabledByBatterySaver, disabledByHoldbackPrefetchSpeculationRules, disabledByHoldbackPrerenderSpeculationRules);
    }
}
