package org.openqa.selenium.devtools.v125.cachestorage;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class CacheStorage {

    /**
     * Deletes a cache.
     */
    public static Command<Void> deleteCache(org.openqa.selenium.devtools.v125.cachestorage.model.CacheId cacheId) {
        java.util.Objects.requireNonNull(cacheId, "cacheId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("cacheId", cacheId);
        return new Command<>("CacheStorage.deleteCache", Map.copyOf(params));
    }

    /**
     * Deletes a cache entry.
     */
    public static Command<Void> deleteEntry(org.openqa.selenium.devtools.v125.cachestorage.model.CacheId cacheId, java.lang.String request) {
        java.util.Objects.requireNonNull(cacheId, "cacheId is required");
        java.util.Objects.requireNonNull(request, "request is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("cacheId", cacheId);
        params.put("request", request);
        return new Command<>("CacheStorage.deleteEntry", Map.copyOf(params));
    }

    /**
     * Requests cache names.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v125.cachestorage.model.Cache>> requestCacheNames(java.util.Optional<java.lang.String> securityOrigin, java.util.Optional<java.lang.String> storageKey, java.util.Optional<org.openqa.selenium.devtools.v125.storage.model.StorageBucket> storageBucket) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", p));
        storageKey.ifPresent(p -> params.put("storageKey", p));
        storageBucket.ifPresent(p -> params.put("storageBucket", p));
        return new Command<>("CacheStorage.requestCacheNames", Map.copyOf(params), ConverterFunctions.map("caches", input -> input.readArray(org.openqa.selenium.devtools.v125.cachestorage.model.Cache.class)));
    }

    /**
     * Fetches cache entry.
     */
    public static Command<org.openqa.selenium.devtools.v125.cachestorage.model.CachedResponse> requestCachedResponse(org.openqa.selenium.devtools.v125.cachestorage.model.CacheId cacheId, java.lang.String requestURL, java.util.List<org.openqa.selenium.devtools.v125.cachestorage.model.Header> requestHeaders) {
        java.util.Objects.requireNonNull(cacheId, "cacheId is required");
        java.util.Objects.requireNonNull(requestURL, "requestURL is required");
        java.util.Objects.requireNonNull(requestHeaders, "requestHeaders is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("cacheId", cacheId);
        params.put("requestURL", requestURL);
        params.put("requestHeaders", requestHeaders);
        return new Command<>("CacheStorage.requestCachedResponse", Map.copyOf(params), ConverterFunctions.map("response", org.openqa.selenium.devtools.v125.cachestorage.model.CachedResponse.class));
    }

    public static class RequestEntriesResponse {

        private final java.util.List<org.openqa.selenium.devtools.v125.cachestorage.model.DataEntry> cacheDataEntries;

        private final java.lang.Number returnCount;

        public RequestEntriesResponse(java.util.List<org.openqa.selenium.devtools.v125.cachestorage.model.DataEntry> cacheDataEntries, java.lang.Number returnCount) {
            this.cacheDataEntries = java.util.Objects.requireNonNull(cacheDataEntries, "cacheDataEntries is required");
            this.returnCount = java.util.Objects.requireNonNull(returnCount, "returnCount is required");
        }

        /**
         * Array of object store data entries.
         */
        public java.util.List<org.openqa.selenium.devtools.v125.cachestorage.model.DataEntry> getCacheDataEntries() {
            return cacheDataEntries;
        }

        /**
         * Count of returned entries from this storage. If pathFilter is empty, it
         * is the count of all entries from this storage.
         */
        public java.lang.Number getReturnCount() {
            return returnCount;
        }

        private static RequestEntriesResponse fromJson(JsonInput input) {
            java.util.List<org.openqa.selenium.devtools.v125.cachestorage.model.DataEntry> cacheDataEntries = null;
            java.lang.Number returnCount = 0;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "cacheDataEntries":
                        cacheDataEntries = input.readArray(org.openqa.selenium.devtools.v125.cachestorage.model.DataEntry.class);
                        break;
                    case "returnCount":
                        returnCount = input.nextNumber();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new RequestEntriesResponse(cacheDataEntries, returnCount);
        }
    }

    /**
     * Requests data from cache.
     */
    public static Command<org.openqa.selenium.devtools.v125.cachestorage.CacheStorage.RequestEntriesResponse> requestEntries(org.openqa.selenium.devtools.v125.cachestorage.model.CacheId cacheId, java.util.Optional<java.lang.Integer> skipCount, java.util.Optional<java.lang.Integer> pageSize, java.util.Optional<java.lang.String> pathFilter) {
        java.util.Objects.requireNonNull(cacheId, "cacheId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("cacheId", cacheId);
        skipCount.ifPresent(p -> params.put("skipCount", p));
        pageSize.ifPresent(p -> params.put("pageSize", p));
        pathFilter.ifPresent(p -> params.put("pathFilter", p));
        return new Command<>("CacheStorage.requestEntries", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v125.cachestorage.CacheStorage.RequestEntriesResponse.class));
    }
}
