package org.openqa.selenium.devtools.v127.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about the Frame on the page.
 */
public class Frame {

    private final org.openqa.selenium.devtools.v127.page.model.FrameId id;

    private final java.util.Optional<org.openqa.selenium.devtools.v127.page.model.FrameId> parentId;

    private final org.openqa.selenium.devtools.v127.network.model.LoaderId loaderId;

    private final java.util.Optional<java.lang.String> name;

    private final java.lang.String url;

    private final java.util.Optional<java.lang.String> urlFragment;

    private final java.lang.String domainAndRegistry;

    private final java.lang.String securityOrigin;

    private final java.lang.String mimeType;

    private final java.util.Optional<java.lang.String> unreachableUrl;

    private final java.util.Optional<org.openqa.selenium.devtools.v127.page.model.AdFrameStatus> adFrameStatus;

    private final org.openqa.selenium.devtools.v127.page.model.SecureContextType secureContextType;

    private final org.openqa.selenium.devtools.v127.page.model.CrossOriginIsolatedContextType crossOriginIsolatedContextType;

    private final java.util.List<org.openqa.selenium.devtools.v127.page.model.GatedAPIFeatures> gatedAPIFeatures;

    public Frame(org.openqa.selenium.devtools.v127.page.model.FrameId id, java.util.Optional<org.openqa.selenium.devtools.v127.page.model.FrameId> parentId, org.openqa.selenium.devtools.v127.network.model.LoaderId loaderId, java.util.Optional<java.lang.String> name, java.lang.String url, java.util.Optional<java.lang.String> urlFragment, java.lang.String domainAndRegistry, java.lang.String securityOrigin, java.lang.String mimeType, java.util.Optional<java.lang.String> unreachableUrl, java.util.Optional<org.openqa.selenium.devtools.v127.page.model.AdFrameStatus> adFrameStatus, org.openqa.selenium.devtools.v127.page.model.SecureContextType secureContextType, org.openqa.selenium.devtools.v127.page.model.CrossOriginIsolatedContextType crossOriginIsolatedContextType, java.util.List<org.openqa.selenium.devtools.v127.page.model.GatedAPIFeatures> gatedAPIFeatures) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.parentId = parentId;
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.name = name;
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.domainAndRegistry = java.util.Objects.requireNonNull(domainAndRegistry, "domainAndRegistry is required");
        this.securityOrigin = java.util.Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        this.mimeType = java.util.Objects.requireNonNull(mimeType, "mimeType is required");
        this.unreachableUrl = unreachableUrl;
        this.adFrameStatus = adFrameStatus;
        this.secureContextType = java.util.Objects.requireNonNull(secureContextType, "secureContextType is required");
        this.crossOriginIsolatedContextType = java.util.Objects.requireNonNull(crossOriginIsolatedContextType, "crossOriginIsolatedContextType is required");
        this.gatedAPIFeatures = java.util.Objects.requireNonNull(gatedAPIFeatures, "gatedAPIFeatures is required");
    }

    /**
     * Frame unique identifier.
     */
    public org.openqa.selenium.devtools.v127.page.model.FrameId getId() {
        return id;
    }

    /**
     * Parent frame identifier.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v127.page.model.FrameId> getParentId() {
        return parentId;
    }

    /**
     * Identifier of the loader associated with this frame.
     */
    public org.openqa.selenium.devtools.v127.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    /**
     * Frame's name as specified in the tag.
     */
    public java.util.Optional<java.lang.String> getName() {
        return name;
    }

    /**
     * Frame document's URL without fragment.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Frame document's URL fragment including the '#'.
     */
    @Beta()
    public java.util.Optional<java.lang.String> getUrlFragment() {
        return urlFragment;
    }

    /**
     * Frame document's registered domain, taking the public suffixes list into account.
     * Extracted from the Frame's url.
     * Example URLs: http://www.google.com/file.html -> "google.com"
     *               http://a.b.co.uk/file.html      -> "b.co.uk"
     */
    @Beta()
    public java.lang.String getDomainAndRegistry() {
        return domainAndRegistry;
    }

    /**
     * Frame document's security origin.
     */
    public java.lang.String getSecurityOrigin() {
        return securityOrigin;
    }

    /**
     * Frame document's mimeType as determined by the browser.
     */
    public java.lang.String getMimeType() {
        return mimeType;
    }

    /**
     * If the frame failed to load, this contains the URL that could not be loaded. Note that unlike url above, this URL may contain a fragment.
     */
    @Beta()
    public java.util.Optional<java.lang.String> getUnreachableUrl() {
        return unreachableUrl;
    }

    /**
     * Indicates whether this frame was tagged as an ad and why.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v127.page.model.AdFrameStatus> getAdFrameStatus() {
        return adFrameStatus;
    }

    /**
     * Indicates whether the main document is a secure context and explains why that is the case.
     */
    @Beta()
    public org.openqa.selenium.devtools.v127.page.model.SecureContextType getSecureContextType() {
        return secureContextType;
    }

    /**
     * Indicates whether this is a cross origin isolated context.
     */
    @Beta()
    public org.openqa.selenium.devtools.v127.page.model.CrossOriginIsolatedContextType getCrossOriginIsolatedContextType() {
        return crossOriginIsolatedContextType;
    }

    /**
     * Indicated which gated APIs / features are available.
     */
    @Beta()
    public java.util.List<org.openqa.selenium.devtools.v127.page.model.GatedAPIFeatures> getGatedAPIFeatures() {
        return gatedAPIFeatures;
    }

    private static Frame fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v127.page.model.FrameId id = null;
        java.util.Optional<org.openqa.selenium.devtools.v127.page.model.FrameId> parentId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v127.network.model.LoaderId loaderId = null;
        java.util.Optional<java.lang.String> name = java.util.Optional.empty();
        java.lang.String url = null;
        java.util.Optional<java.lang.String> urlFragment = java.util.Optional.empty();
        java.lang.String domainAndRegistry = null;
        java.lang.String securityOrigin = null;
        java.lang.String mimeType = null;
        java.util.Optional<java.lang.String> unreachableUrl = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v127.page.model.AdFrameStatus> adFrameStatus = java.util.Optional.empty();
        org.openqa.selenium.devtools.v127.page.model.SecureContextType secureContextType = null;
        org.openqa.selenium.devtools.v127.page.model.CrossOriginIsolatedContextType crossOriginIsolatedContextType = null;
        java.util.List<org.openqa.selenium.devtools.v127.page.model.GatedAPIFeatures> gatedAPIFeatures = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v127.page.model.FrameId.class);
                    break;
                case "parentId":
                    parentId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v127.page.model.FrameId.class));
                    break;
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v127.network.model.LoaderId.class);
                    break;
                case "name":
                    name = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "urlFragment":
                    urlFragment = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "domainAndRegistry":
                    domainAndRegistry = input.nextString();
                    break;
                case "securityOrigin":
                    securityOrigin = input.nextString();
                    break;
                case "mimeType":
                    mimeType = input.nextString();
                    break;
                case "unreachableUrl":
                    unreachableUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "adFrameStatus":
                    adFrameStatus = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v127.page.model.AdFrameStatus.class));
                    break;
                case "secureContextType":
                    secureContextType = input.read(org.openqa.selenium.devtools.v127.page.model.SecureContextType.class);
                    break;
                case "crossOriginIsolatedContextType":
                    crossOriginIsolatedContextType = input.read(org.openqa.selenium.devtools.v127.page.model.CrossOriginIsolatedContextType.class);
                    break;
                case "gatedAPIFeatures":
                    gatedAPIFeatures = input.readArray(org.openqa.selenium.devtools.v127.page.model.GatedAPIFeatures.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Frame(id, parentId, loaderId, name, url, urlFragment, domainAndRegistry, securityOrigin, mimeType, unreachableUrl, adFrameStatus, secureContextType, crossOriginIsolatedContextType, gatedAPIFeatures);
    }
}
