/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.runtime.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v128.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PrivatePropertyDescriptor {
    private final String name;
    private final Optional<RemoteObject> value;
    private final Optional<RemoteObject> get;
    private final Optional<RemoteObject> set;

    public PrivatePropertyDescriptor(String name, Optional<RemoteObject> value, Optional<RemoteObject> get, Optional<RemoteObject> set) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = value;
        this.get = get;
        this.set = set;
    }

    public String getName() {
        return this.name;
    }

    public Optional<RemoteObject> getValue() {
        return this.value;
    }

    public Optional<RemoteObject> getGet() {
        return this.get;
    }

    public Optional<RemoteObject> getSet() {
        return this.set;
    }

    private static PrivatePropertyDescriptor fromJson(JsonInput input) {
        String name = null;
        Optional<RemoteObject> value = Optional.empty();
        Optional<RemoteObject> get = Optional.empty();
        Optional<RemoteObject> set = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "value": {
                    value = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block12;
                }
                case "get": {
                    get = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block12;
                }
                case "set": {
                    set = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrivatePropertyDescriptor(name, value, get, set);
    }
}

