package org.openqa.selenium.devtools.v130.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to mojom::SpeculationTargetHint.
 * See https://github.com/WICG/nav-speculation/blob/main/triggers.md#window-name-targeting-hints
 */
public enum SpeculationTargetHint {

    BLANK("Blank"), SELF("Self");

    private String value;

    SpeculationTargetHint(String value) {
        this.value = value;
    }

    public static SpeculationTargetHint fromString(String s) {
        return java.util.Arrays.stream(SpeculationTargetHint.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SpeculationTargetHint "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SpeculationTargetHint fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
