package org.openqa.selenium.devtools.v131.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of network fetches auctions can do.
 */
public enum InterestGroupAuctionFetchType {

    BIDDERJS("bidderJs"), BIDDERWASM("bidderWasm"), SELLERJS("sellerJs"), BIDDERTRUSTEDSIGNALS("bidderTrustedSignals"), SELLERTRUSTEDSIGNALS("sellerTrustedSignals");

    private String value;

    InterestGroupAuctionFetchType(String value) {
        this.value = value;
    }

    public static InterestGroupAuctionFetchType fromString(String s) {
        return java.util.Arrays.stream(InterestGroupAuctionFetchType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within InterestGroupAuctionFetchType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static InterestGroupAuctionFetchType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
