package org.openqa.selenium.devtools.v131.fedcm.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The URLs that each account has
 */
public enum AccountUrlType {

    TERMSOFSERVICE("TermsOfService"), PRIVACYPOLICY("PrivacyPolicy");

    private String value;

    AccountUrlType(String value) {
        this.value = value;
    }

    public static AccountUrlType fromString(String s) {
        return java.util.Arrays.stream(AccountUrlType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AccountUrlType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AccountUrlType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
