package org.openqa.selenium.devtools.v139.pwa.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * If user prefers opening the app in browser or an app window.
 */
public enum DisplayMode {

    STANDALONE("standalone"), BROWSER("browser");

    private String value;

    DisplayMode(String value) {
        this.value = value;
    }

    public static DisplayMode fromString(String s) {
        return java.util.Arrays.stream(DisplayMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DisplayMode "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DisplayMode fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
